//------------------------------------------------------------------------------
// File: client_tasklistener.cs
// This file contains all task dialog strings. Task dialog strings are added
// and removed dynamically from the string table when tasks are activated and
// deactivated (or completed). The task name concatenated with "Active" is
// the method that is called to add and remove the task strings. These methods
// must be scoped with the TaskListener object.
//------------------------------------------------------------------------------

function TaskListener::GlobalTasksActive(%this, %bActive)
{
 slgUpdateTaskStrings(%bActive, "ID_HeroDeathTutorial", "Oh no! Your hero fell in combat. Not to worry though, unlike other units, Heroes slowly heal. Once your Hero reaches full health, you'll be ready for action again.");
}

function TaskListener::HappinessTasksActive(%this, %bActive)
{
   slgUpdateTaskStrings(%bActive, "ID_Saloon", "Folks in this town are so sad, they could use a nice place to drown their sorrows. I know, you should build a saloon.");
   slgUpdateTaskStrings(%bActive, "ID_Salooncmpt", "That's a mighty fine saloon. Should keep people's attention pretty well.");
   slgUpdateTaskStrings(%bActive, "ID_gazebo", "Ya know what a gazebo is? I've always liked gazebos. This town'd be a lot happier if it had a gazebo. Hah, I love to say gazebo.");
   slgUpdateTaskStrings(%bActive, "ID_gazebocmpt", "That's a nice little gazebo. That'll give people somewhere to relax.");
   slgUpdateTaskStrings(%bActive, "ID_statue", "There's pigeons roosting all over the buildings, and it's startin' to upset people. If we built up a statue, they'd have somewhere else to sit.");
   slgUpdateTaskStrings(%bActive, "ID_statuecmpt", "That's a purdy statue. Now if only it didn't look so much like the Mayor.");
   slgUpdateTaskStrings(%bActive, "ID_fountain", "This place is too doggone dusty, and it's gettin' me down. Ya know what'd be nice? A fountain.");
   slgUpdateTaskStrings(%bActive, "ID_fountaincmpt", "That burbling fountain is nice and soothing.");
   slgUpdateTaskStrings(%bActive, "ID_church", "People around here are mighty sorrowful. I'm sure a church'd brighten their spirits.");
   slgUpdateTaskStrings(%bActive, "ID_churchcmpt", "Hallelujah. That church should keep people nice and happy.");
}

function TaskListener::BadgeTasksActive(%this, %bActive)
{
   slgUpdateTaskStrings(%bActive, "ID_Honeypot", "All these flower pots are bringing a whole mess of bees into town. I bet we could get some honey from 'em if we built some beehives.");
   slgUpdateTaskStrings(%bActive, "ID_Honeybear", "Uh-oh... all that honey brought a bear into town! Good boy... good boy... nice boy. Hey... he's pretty friendly.");
}

function TaskListener::TutorialTasksActive(%this, %bActive)
{
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALSTARTONE", "Welcome to Westward II. In this Tutorial, you'll learn how to build yourself a profitable, happy town on the frontier. Let's start with the most basic stuff first.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALSTARTTWO", "First off, you'll have to select your Hero, by left-clicking on him.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALSTARTTWOher", "First off, you'll have to select your Hero, by left-clicking on her.");   
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALSELECT", "Howdy! When someone wants to talk to you about something, an exclaimation point will appear over their head. Click on it to see what's up.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALMOVETALK", "To move a character around the West, left-click and drag them where you want them to go. Try moving me over near that water barrel now.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALMOVEARRIVE", "Great! You can also use Ctrl + Left-Click or Right-Click(if your mouse has one) on the map to tell a character to walk there. Now try moving me to the road sign.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALSCANMOVE", "Lookie there! There's someone else a bit further to the south-east.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALMapMovement", "To look at other parts of the map, move the mouse cursor to the edge of the screen in the direction you want to look. Go ahead and move me over to the Citizen.");
   slgUpdateTaskStrings(%bActive, "id_tutorialzoom", "Excellent! To zoom in and out use the scroll wheel on your mouse. Alternatively you can use the + or - keys. You can find more keyboard shortcuts in the Westward II Help file.");

   // Teach Build Button/Shack
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALSCANARRIVEONE", "Howdy there. My cabin burned down. I'd really love to have a new place to live. I'll even give you a hand if you'll help me out.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALBuild", "To build a Shack for the Citizen, select your Hero and click on the Axe and Saw button.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALBuildTwo", "Then click on the Shack button in the upper-left of the Building Menu.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALBuildThree", "Finally, click on the map in a clear area where the picture of the Shack is green.");
   // Teach Food Resources: pickup
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALSHACK", "It's not much, but at least it's somethin'.  Now then, whatcha got to eat?");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALFoodResource", "Your Citizens need Food as well as places to live.  The Food display shows how much Food you have and the maximum Food you can store.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALCollectBerry", "One way to collect Food is to move one of your characters onto a berry bush. Try that with one of the bushes by the ruined Cabin.");
   // Teach Food Resources: Farm
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALPICKUPFOOD", "That's nice, but we need a more steady source of Food. Build a Well so we have enough Water to supply a Farm.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALWellSelect", "To build a Well, select a character and click on the Axe and Saw button.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALWellBuild", "Then click on the Well button from the Building Menu and place the Well on the map in a clear area.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALWELL", "Well, that's the Well done. Now build a Farm.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALFARM", "Great. Employ the Citizen at the Farm by selecting him and dragging him onto the Farm.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALEmployHammer", "The Hammer icons above the building show the number of people employed at the building and the total number of people that can be employed there.");
   // Housing  
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALHeroCantEmploy", "I'd pitch in myself, but my job is to explore the area and protect the town from danger. I can't do that if I'm working at a Farm. I'll help out with everything else, but I can't be tied down to a steady job.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALEMPLOYFARM", "We need more people. Building extra housing--Shacks, Log Cabins, and Hotels--brings Citizens into town. Build a second Shack. Another Citizen will come shortly after it's done.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALSECONDSHACK", "Wonderful. Employ the new Citizen at the Farm when he or she shows up. The more people employed at a building, the more efficiently that building will run.");
   // Experience 
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALSECONDEMPLOY", "Look at that, you've gained some Experience. You gain Experience by completing quests and building things for the first time. It's used for unlocking upgrades and new buildings.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALXpStore", "You've gained enough Experience to unlock the Wood Hut. To do this, click on the Store button at the top of the screen, then on the Buy button beside the Wood Hut's entry.");
   // Wood Hut
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALXPLUMBER", "Great, now that you've unlocked the Wood Hut from the store, you can build one and start gathering some Wood. ");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALWoodhutTrees", "Wood Huts need to be built near trees in order to harvest Wood. When you have the Wood Hut selected, the trees that can be harvested will brighten. You'll want to build the Wood Hut in a spot that has as many trees as possible highlighted.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALWoodhutplace", "I'll just clear these rocks at the edge of the forest away. That'll be a great place to build a Wood Hut.");
   // Quit job
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALLUMBERBUILD", "Now we need someone working at the Wood Hut. Have someone quit their job at the Farm by selecting them and clicking the Job Whistle button, and then employ them at the Wood Hut.");
   // Extra Wood pickups
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALLUMBERBUILDCOMPLETE", "Well done. Now collect 100 Wood. The more people you have working at your Wood Hut, the faster you'll gather Wood.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALExtraWoodprops", "You can gather a little extra Wood by dragging characters onto Wood piles and fallen logs.");
   // Unlock goldmine
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALWOODCOMPLETE", "You've gathered all the Wood you need, and you've earned enough Experience to unlock the Gold Mine from the Store. You should do so now.");
   // Build goldmine
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALXPMINE", "Great, now that you've unlocked the Gold Mine you can build one and get some Gold.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALXPMINE2", "Gold Mines need to be placed on top of Gold Veins.  There is one south of where you started, on the other side of the canyon.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALMINEBUILD", "Now employ someone at the Gold Mine. Since you don't need any more Wood right now, have your Citizen at the Wood Hut quit their job and employ them at the Gold Mine.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALMINEBUILDCOMPLETE", "Well done. Now collect 50 Gold. Remember that the more people you have working at your Gold Mine, the faster you'll gather Gold.");
   // Combat and Lasso
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALRAIDGUNARRIVE", "Howdy Partner. That gold you're haulin' up is attractin' unsavory sorts. Best bring your Hero over near the mine to give us a hand defending it.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALFindHero", "To find your Hero quickly, click on the icon of the Hero's image at the bottom left of the screen. This will move you to the Hero's current location.");
   
   // Find Unit Dialogs 
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALNextJobless", "Clicking on the other buttons around the Minimap will take you to other characters or buildings. The Next Unemployed Citizen button allows you to quickly find characters who need jobs.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALNextCitizen", "The Next Citizen button cycles through all of your Citizens.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALNextBuilding", "The Next Building button cycles through all of your buildings, allowing you to quickly find buildings without employees.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALNextCombat", "The Find Next Combat Unit button comes in handy when your town is under attack. It cycles through your Sheriff, Gunslingers, and Deputies.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALminimap", "Between the Unit Selection buttons is the Minimap. Your units and buildings show up in blue, neutral ones in green, and enemy ones in red. You can Left-Click on a spot on the Minimap to be taken to that spot on the screen.");
      
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALBanditIntro", "Great, you're here. There's a Bandit on his way over here. We better work together to take him on.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALLassoteach", "To select multiple characters, click near one of them, hold down your mouse button, then drag until the selection box is around the characters you want to select. Select both Gunslingers now.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALLassosuccess", "Good job. Now we'll be ready for him. ");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALRAIDBANDITARRIVE", "Hyuck Hyuck Hyuck. I'm here for the Gold. Hand it over.");
   // Health Bar   
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALRAIDLASSO", "Select both Gunslingers and then drag one of them onto the Bandit to attack him. Keep an eye on the green bars over the Gunslingers and the red bar over the Bandit, they represent the character's health.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALRAIDDEFEAT", "That's got him dealt with. Thanks for the help, I couldn't have done it without you.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALGunWork", "Say, how about you two gunslingers givin' us a hand with the mining?");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALNoWork", "Heh. Sorry, we don't do manual labor. If it's gold you're after though, there are a few bags stashed around this area.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALGOLDCOMPLETE", "You've gathered all the Gold you need.");
   slgUpdateTaskStrings(%bActive, "ID_TUTORIALCOMPLETE", "Congratulations. You've completed the tutorial and unlocked Sandbox Mode, where you can build the town of your dreams. Let me know when you're ready to leave this little settlement behind and get on with the game.");
}

function TaskListener::StartTasksActive(%this, %bActive)
{
   slgUpdateTaskStrings(%bActive, "ID_STARTSTART", "Look at this open land... ain't it grea-- wait-a-minute... who's that guy?");
   // Wood for Goldvein 
   slgUpdateTaskStrings(%bActive, "ID_WOODSTART", "Well howdy there. You stuck out here in the middle of nowhere too? Bet you ain't got a secret like mine. Tell you what? You gimme a hand with gatherin' up some wood to repair my old wood hut, and I'll let you in on that secret.");
   slgUpdateTaskStrings(%bActive, "ID_WOODEXPLAIN", "Yup, I'll show you where I done hid a big ol' gold mine and I'll help you make somethin' outta this stretch a nowhere, and all you gotta do is get me 100 planks of wood.");
   slgUpdateTaskStrings(%bActive, "ID_WOODGO", "So how's 'bout it? You ready to hand off that 100 planks of wood?");
   slgUpdateTaskStrings(%bActive, "ID_WOODMINE", "Right! Location of one mine comin' right up. Ta-da! I covered it in clay so it'd look like a great big rock. Pretty cunnin' eh?");
   slgUpdateTaskStrings(%bActive, "ID_WOODJoin", "Tell ya what. If you let me join ya, I'll hand over the keys to that wood hut.");
   slgUpdateTaskStrings(%bActive, "ID_WOODJoinAccept", "That's right neighborly of you.  Here's the keys, maybe you can get the wood hut workin'.");
   
   // FOOD AND FARM Intro food for Granary task
   slgUpdateTaskStrings(%bActive, "ID_FOODSTART", "Howdy stranger, I've been out here for months and can't get nothin' to grow but rocks and weeds.");
   slgUpdateTaskStrings(%bActive, "ID_FOODEXPLAIN", "I'll give you the plans for my granary if you can manage to build a farm and grow 22 bushels of food.  Granaries are great for storing extra food in case of droughts or a whole swarm of in-laws come to town.");
   slgUpdateTaskStrings(%bActive, "ID_FOODAccept", "So, think you can do better than I did with that farm?");
   slgUpdateTaskStrings(%bActive, "ID_FOODAccept2", "Heh. Good luck. I'll be waiting over near the road sign. Let me know when you have the food ready.");
   slgUpdateTaskStrings(%bActive, "ID_FOODFarm", "Well, building the farm is the easy part, lets see if you can get anything to grow.");
   slgUpdateTaskStrings(%bActive, "ID_FOODGO", "You got that food all ready for me? 22 bushels, remember.");
   slgUpdateTaskStrings(%bActive, "ID_FOODDONE", "Mmmm-mm. That looks downright de-lectable. Here's some plans for how to build a nice granary. See ya' 'round.");
   // Gold for LogCabin Plans
   slgUpdateTaskStrings(%bActive, "ID_GOLDEXPLAIN", "Well don't this place just have heaps of potential. Howdy do? I'm Fremont Auren, and I'd like to help ya'll out.");
   slgUpdateTaskStrings(%bActive, "ID_GOLDEXPLAIN2", "Course, I do need a little help myself too. Just 100 gold, to get my sister outta debt, y'see? In exchange, I'll work as hard as anyone else, and show you how to make some houses a bit nicer than these here shacks you got now.");
   slgUpdateTaskStrings(%bActive, "ID_GOLDGO", "You ready to send that 100 gold off to my sister to help her out?");
   slgUpdateTaskStrings(%bActive, "ID_GOLDUNLOCK", "Great! Wonderful! I'll go deliver the gold to my sister. Here's some plans for buildin' a log cabin. If you build up something that don't look like a sneeze'd knock it down, and I bet we could get my sister over here too.");
   slgUpdateTaskStrings(%bActive, "ID_GOLDCOMPLETE", "Now that's a right nice looking cabin, brother dear. This town has positive oodles of potential. Of course, with my help, it'll be all the better. Let's get started.");   
   // Quest Log
   slgUpdateTaskStrings(%bActive, "ID_QuestIcon", "You have just received a Quest.  Steps for a Quest can be viewed in the upper left corner of the screen.  The number of Quests currently open is indicated by the number of horseshoe and scroll icons.  Selecting one of these icons displays the steps for that Quest.");
   slgUpdateTaskStrings(%bActive, "ID_QuestPage", "The Quest Page shows all of the Quests that you have completed and the ones you are currently working on as well as their steps. You can open the Quest Page by clicking on the Quests button at the top of the screen.");
   // Wilkins Hut
   slgUpdateTaskStrings(%bActive, "ID_Mywoodhut", "This Wood Hut doesn't belong to us, so we won't be able to Repair it or Employ anyone here.");
   slgUpdateTaskStrings(%bActive, "ID_Wilkinshut", "Wilkins Wood Shack is owned by Mr. Evan Wilkins. Maybe you should talk to me--I mean him if you want something from it.");
   // Happiness Tutorial
   slgUpdateTaskStrings(%bActive, "ID_Happytutstart", "Your town is growing nicely but more people means more responsibility. As your population grows, your Town Happiness will drop.");
   slgUpdateTaskStrings(%bActive, "ID_Happytutnext", "High Town Happiness increases town productivity, causes new Citizens to move into your town quickly, and prevents Citizens from leaving as quickly when they are unhappy. A low Town Happiness turns all those positives into negatives.");
   slgUpdateTaskStrings(%bActive, "ID_Happytutnext1", "Many buildings increase Town Happiness, while others lower it. Heavily damaged buildings also lower Town Happiness, as do homeless, hungry, and jobless Citizens.");
   // Hidden gold hint
   slgUpdateTaskStrings(%bActive, "ID_hiddengold", "There's gold in these rocks, but we're going to need to blast to get it out. You can buy dynamite at the general store after you unlock it with a bit of experience.");
}

function TaskListener::GeneralTasksActive(%this, %bActive)
{
   // Treasure hunt 1
   slgUpdateTaskStrings(%bActive, "ID_fishmapfound", "Hey there is some old parchment in the fish's mouth. Says something about 'Find the 5 cow skulls and my treasure will be yours.' Well ain't that spiffy--a real treasure hunt.");
   slgUpdateTaskStrings(%bActive, "ID_fishmapskull1", "There's some torn up paper stuffed in this cow skull. It's got writin' on it, maybe '...treasure under...' or something like it.");
   slgUpdateTaskStrings(%bActive, "ID_fishmapskull2", "There's some more parchment in this cow skull. It's got all sorts of bits and pieces of letters on it, I think it says '...I could find.'");
   slgUpdateTaskStrings(%bActive, "ID_fishmapskull3", "Found a bit of shredded paper tucked away under this skull. It says 'I buried my...' Well dang. That ain't no help.");
   slgUpdateTaskStrings(%bActive, "ID_fishmapskull4", "Hrm... there's some paper here, it says '...oak tree...'");
   slgUpdateTaskStrings(%bActive, "ID_fishmapskull5", "I found some torn up paper under that cow skull. it says, '...the largest...'");
   slgUpdateTaskStrings(%bActive, "ID_fishmapskullcomplete", "Let's put the whole thing together now. The handwriting ain't the best, but I think it says 'I buried my treasure under the largest oak tree I could find.'");
   slgUpdateTaskStrings(%bActive, "ID_fishmaptreasure", "This tree is the biggest in the area. Woah... will you look at all that gold.");
   
   // Famine Trigger 
   slgUpdateTaskStrings(%bActive, "id_famineload", "It's dang good to see y'all. Ya gotta help us, the Copperheads is tryin' to drive us off of our land by poisonin' our wells. If we don't get some help soon, we're gonna have to fold.");
   
   // Sasquatch/Disaster Badge - From the Sasquatch or an Out-of-character logo.
   slgUpdateTaskStrings(%bActive, "id_sassybadge", "As a reward for taming the wilds of the Disaster Challenge, the enigmatic Sasquatch will help guard your town from interlopers.");

}

function TaskListener::MainmapTasksActive(%this, %bActive)
{
   // Platform unlock text
   slgUpdateTaskStrings(%bActive, "ID_PlatformDude", "This here buncha boards used t'be a mighty fine outpost till those dadgummed bandits blocked the road off east.");
   slgUpdateTaskStrings(%bActive, "ID_Platformone", "That's a dang shame.  Anything we can do?");
   slgUpdateTaskStrings(%bActive, "ID_Platformtwo", "Well. If you was to blast the boulders outta the wagon trail, I could make sure traders know this route's open ag'in.");
   slgUpdateTaskStrings(%bActive, "ID_rockblast", "There goes that rock. Dang fine boom, too.");
   slgUpdateTaskStrings(%bActive, "ID_Platformunlock", "That should deal with the rock problem. Just put a little work into this ol' platform an' you can have a right nice outpost.");
   slgUpdateTaskStrings(%bActive, "ID_Platformguns", "What are you playin' at? We just got some nice peace and quiet from all those clackin' wagons and you come by blastin' things? What's a gal gotta do to get some rest?");
   slgUpdateTaskStrings(%bActive, "ID_PlatformOpenroad", "You blocked the wagon trail to keep things quiet? Well, I'm sorry to say, we need the trail clear. What can I do to make it up to you?");
   slgUpdateTaskStrings(%bActive, "ID_PlatformNewcabin", "Well, I guess if ya' build us a nice cabin a little ways back from the wagon trail we wouldn't have to keep puttin' rocks in the way.");
   slgUpdateTaskStrings(%bActive, "ID_Platformbuiltcabin", "That looks just fan-tastic. You won't have no trouble from us with that trail of yours no more.");
   slgUpdateTaskStrings(%bActive, "ID_Platformoutpost", "That's got us all set. Tell you what. Since I done run this outpost all my life, why don't you just put some place together for me to live, and I'll keep right at it.");
   slgUpdateTaskStrings(%bActive, "ID_PlatformcabinReject", "That ain't no better and you know it. It's gotta be far 'nough away from the trail that we can't hear those ding-dang wagons.");
   
   // Hope River Refugee text
   slgUpdateTaskStrings(%bActive, "ID_Refugeehelp", "Oh... I'm glad we made it. It's horrible... he burned all of Hope River.");
   slgUpdateTaskStrings(%bActive, "ID_Refugeehelp1", "I'd recognize that uniform anywhere. It was the Mad Russian alright. We don't have homes anymore. Some of us are willing to help out here just like we did in Hope River if you'll let us stay.");
   slgUpdateTaskStrings(%bActive, "ID_Refugeehelp2", "Of course I will. Let's get you folks some place to live. Then we can talk about what to do about the Mad Russian... I should have known he'd never stay in jail.");
   slgUpdateTaskStrings(%bActive, "ID_Refugeefood", "There are a few people trying to build Hope River back up, but they ran out of food even before we left. We need to send 50 bushels of food back there as soon as we can.");
   slgUpdateTaskStrings(%bActive, "ID_Refugeeherohelp", "That's a whole lot of food. It'll probably take a while to gather up, but we'll get these folks a place to live right away.");
   slgUpdateTaskStrings(%bActive, "ID_Refugeefoodaccept", "Ready to send those 50 bushels of food back to Hope River yet?");
   slgUpdateTaskStrings(%bActive, "ID_Refugeefoodgive", "This'll help a whole lot. I'll hurry back to what's left of Hope River.");
   slgUpdateTaskStrings(%bActive, "id_hoperescue_start", "Those dad-blamed Copperheads were just waiting for us to try to come back here. I barely got away, but they captured the others. You gotta go help 'em.");
   slgUpdateTaskStrings(%bActive, "id_hoperescue_hero", "Seems like I do have to help out. Which way did they go?");
   slgUpdateTaskStrings(%bActive, "id_hoperescue_directions", "They went way deeper into Copperhead territory. Better bring as many gunslingers as you can, I don't think they're gonna be open to negotiations.");
   slgUpdateTaskStrings(%bActive, "id_hoperescue_accept", "You got a good sized rescue party ready?  I'll show you where they ambushed us.");
   slgUpdateTaskStrings(%bActive, "ID_RefugeeReturn", "Thanks for saving us. I hope you dont mind if we make our new home here.");
   slgUpdateTaskStrings(%bActive, "ID_RefugeeEnd", "I'll be going back to what's left of Hope River now. Here's a little somethin' for your time. It ain't much, but it's what we can spare. Best make sure the same thing doesn't happen here.");
   slgUpdateTaskStrings(%bActive, "id_notenoughcombat", "I'd suggest hiring a few more gunslingers or deputies. Three or four should be enough. There was a lot of them Bandits, and you're likely to need the extra firepower.");
   
   // Job Hunt text
   slgUpdateTaskStrings(%bActive, "ID_Jobhuntstart", "I quit my old job and moved West to find my calling. Thing is I ain't sure what that is. but I'm sure I wanna work outdoors. You think you can gimme a job?");
   slgUpdateTaskStrings(%bActive, "ID_Jobhuntaccept", "Thank ya' kindly. Jus' find me some place t'live an' show me whatcha got for me to do.");
   slgUpdateTaskStrings(%bActive, "ID_Jobhuntemployone", "This don't look too bad. I'll let ya' know what I think.");
   slgUpdateTaskStrings(%bActive, "ID_Jobhuntquitone", "Ya' know, this just ain't what I had in mind.  Ya' got anything else?  Maybe somethin' using rope?");
   slgUpdateTaskStrings(%bActive, "ID_Jobhuntemploytwo", "Hrm... maybe this'll do. I'll give it a go.");
   slgUpdateTaskStrings(%bActive, "ID_Jobhuntquittwo", "Okay, that really ain't for me.  What else ya' got?  Maybe somethin' working with animals?");
   slgUpdateTaskStrings(%bActive, "ID_Jobhuntemploythree", "I'm startin' to get frustrated. Think I'll just head back home if this ain't what I was lookin' for.");
   slgUpdateTaskStrings(%bActive, "ID_Jobhuntquitthree", "That's it, I'm packin' up and headin' home. At least ya' tried though, here's a little somethin' for your time.");
   slgUpdateTaskStrings(%bActive, "ID_Jobhuntcomplete", "This is it, this is the one. Tell you what, I'm mighty thankful that you gave me a chance. My old job was building outhouses, and I'll show you how to slap 'em together if you want, or I suppose I could toss 100 gold your way if you'd prefer?");
   slgUpdateTaskStrings(%bActive, "ID_Jobhuntgold", "I really do appreciate it. I had a bit of gold and some wood stashed, just in case this didn't work out, an' it's all yours.");
   slgUpdateTaskStrings(%bActive, "ID_Jobhuntouthouse", "So you want to learn to make outhouses? I guess I see how that would be more important than gold to some folks.");
   // Hired Gun, Bandit warning
   slgUpdateTaskStrings(%bActive, "id_gunslinger_intro", "Nice little place you got here, but you built your town in the land that the notorious Copperhead Gang claims.  If they don't already know you're here, they will soon.");
   slgUpdateTaskStrings(%bActive, "id_gunslinger_warn", "But hey, it ain't all bad news. You give us 50 ounces of gold, and we'll help you out. You need any more guns, just build a saloon and you'll attract some of sharpest shooters in the West.");
   slgUpdateTaskStrings(%bActive, "id_gunslinger_offer", "What do ya' say? Only 50 gold, and a bargain at twice the price.");
   slgUpdateTaskStrings(%bActive, "id_loneattack", "That gold belongs to the Copperheads, friend. Outta the way.");
   slgUpdateTaskStrings(%bActive, "id_lonedefeat", "I don't think that's gonna be the last of 'em.  We're gonna need some lawmen to really protect the town.");
   // Dual Attack
   slgUpdateTaskStrings(%bActive, "id_Dualattack", "You may've taken down our buddy, but there's more of us where he came from.");
   slgUpdateTaskStrings(%bActive, "id_dualdefeat", "This ain't over. You ain't seen the last of the Copperheads.");   
   slgUpdateTaskStrings(%bActive, "id_Dualwarninggold", "There's more of those Copperheads coming. I think they're headed for the gold vein.");   
   slgUpdateTaskStrings(%bActive, "id_Dualwarninggoldmine", "There's more of those Copperheads coming. I think they're headed for the gold mine. If we don't get a sheriff's office, they'll just keep comin'.");   
   slgUpdateTaskStrings(%bActive, "id_Dualsheriffattack", "Oh, so you got a sheriff's office, do ya? Not for long ya don't.");   
   slgUpdateTaskStrings(%bActive, "id_Dualnosheriff", "Oh, what happened to that pretty sheriff's office of yours? Heh heh. Don't worry, that gold mine looks like easy pickin's.");   
   slgUpdateTaskStrings(%bActive, "id_Dualsheriffdefeat", "That should be the last attack we get outta them. But it might be a good idea to hire a few more guns just in case.");   
   slgUpdateTaskStrings(%bActive, "id_dualNeedSheriff", "I don't think they'll stop pestering us until we've got a sheriff in town.");
   // Food low notification
   slgUpdateTaskStrings(%bActive, "id_warnfoodlow", "Your town is out of food.  Citizens will begin to leave town if they are hungry for too long.");
   // Boom Town task
   slgUpdateTaskStrings(%bActive, "ID_BoomtownIntro", "Gunslingers are fine for dealing with one or two bandits, but unless we get some law in this town, those rustlers'll just keep showing up.");
   slgUpdateTaskStrings(%bActive, "ID_BoomtownTask", "Sheriffs don't usually work in small towns, 'cause the pays not so good. Once we have 15 buildings, we can build a sheriff's office.");
   slgUpdateTaskStrings(%bActive, "ID_BoomtownOfficeUnlock", "This town's probably big enough to lure a sheriff out here now. Let's get an office built up for him.");
   // TODO: to check for Sheriff's Office being built. Hero says:
   // Sheriff Build
   slgUpdateTaskStrings(%bActive, "ID_SheriffBuild", "Now we just gotta decide what sort of sheriff we want to hire. Some sheriffs are right good at keeping law and order, but not so good at making friends. Others are great at kissing babies, but not so good in a fight.");
   // Unlock Sheriffs Office
   slgUpdateTaskStrings(%bActive, "id_freedeputy", "You've been puttin' on a dang good show of whoopin' those bandits. You hire me on to help out, I might even be convinced to show you how gettin' a Sheriff in town works.");
   slgUpdateTaskStrings(%bActive, "id_freesheriffsOffice", "Gimme 120 ounces of gold and you get a loyal deputy and I show you how to build a sheriff's office. Now ain't that a bargain?");   
   // Sheriff Hire
   slgUpdateTaskStrings(%bActive, "ID_ToughSheriffHire", "You made the right choice of sheriffs. Now just whistle up a few more gunslingers and we'll stomp out that little bandit problem of yours once and for all.");
   slgUpdateTaskStrings(%bActive, "ID_NiceSheriffHire", "Well howdy! I'm mighty glad you hired me on. Let's see what we can do about sprucing up this purty little town.");
   // Bridge Tutorial
   slgUpdateTaskStrings(%bActive, "ID_BridgeTutorial", "We've got everything we need to build bridges now. I heard there was a flood up a ways in the hills. Why don't we go out there so they can show us how to span a river? Everything'll be just fine here when we get back.");
   
   // Stranded
   slgUpdateTaskStrings(%bActive, "id_strandedhelp", "Looks like this bridge is out too. All of our bridges across the Rollin' River have been destroyed and bandits are making it impossible for us to build new ones. They're trying to starve us into surrender!");
   slgUpdateTaskStrings(%bActive, "id_strandedwait", "If you can spare any guns and can reach the road sign across the river I'll be waiting there. We'll gladly pay you for your trouble.");
   slgUpdateTaskStrings(%bActive, "id_strandedready", "You got enough guns? Those bandits what blew up our bridges mean business. Whenever you're ready, we'll go deal with our problem and then you can come right back here.");
   // Lumber Mill Reminder   
   slgUpdateTaskStrings(%bActive, "ID_BuildBridgeReminder", "Say, if we want to get across the river, we're going to need a bridge. We'll need nice straight planks from a lumber mill to build a bridge, or anything else very fancy.");
   
   // Deadmine Trigger
   slgUpdateTaskStrings(%bActive, "id_deadminegoldloss", "We aren't pulling as much gold up out of our mine as we used to. It's almost like someone's stealing our gold before we can even mine it.");
   slgUpdateTaskStrings(%bActive, "id_deadminecamp", "Now that I think about it... there's been a lot of bustle out at that dig site across the river. What say we pay them a visit and make sure they're not up to anything devious?"); 
   slgUpdateTaskStrings(%bActive, "id_DMmapzonetrigger", "What d'you want? Get away from here."); 
   slgUpdateTaskStrings(%bActive, "id_DMmapzoneask", "So exactly where does this little cave of yours go?"); 
   slgUpdateTaskStrings(%bActive, "id_DMmapzonepanic", "Uh-oh, they're on to us."); 
   slgUpdateTaskStrings(%bActive, "id_DMmapzoneattack", "Quiet you fool! Aw heckfire. Now we gotta take 'em out."); 
   slgUpdateTaskStrings(%bActive, "id_DMmapgundefeat", "I knew there was something suspicious going on here. I've seen people eager to protect their claim, but they went for their guns pretty quick. Let's check that cave out.");
   slgUpdateTaskStrings(%bActive, "id_DMmapcave", "That cave looks mighty deep. Maybe we should see what they've been up to down there."); 
   slgUpdateTaskStrings(%bActive, "id_DMmapaccept", "You ready to go investigate the cave? Once we're done down there, we'll get back to working on the town."); 
   // Badseed Trigger
   slgUpdateTaskStrings(%bActive, "id_badseedload", "Now this is a right-pretty town. Wish our town were this nice. 'Course, it won't even be our town if that dirty, low-down farmer keeps buyin' up every building in it. Will you give us a hand?"); 
   // Main Map Story
   slgUpdateTaskStrings(%bActive, "id_storyarc", "It's starting to get mighty spooky how there are always Copperheads around this town. I didn't know better, I'd think someone was keeping tabs on us.");
   slgUpdateTaskStrings(%bActive, "id_townspythreat", "Hah! You don't know better. Well, I suppose you do now. The Mad Russian says hello. Fire in the hole!");
   slgUpdateTaskStrings(%bActive, "id_townspyplea", "Uh... all of a sudden I got explosive amnesia. I ain't gonna remember nothin' 'till I'm somewhere nice and safe--and that ain't in this town.");
   slgUpdateTaskStrings(%bActive, "id_townspybargain", "You get me out of town safe-like, I might be able to remember somethin' besides that there's some other person up in Rock Ridge keepin' tabs on the folks there.");
   slgUpdateTaskStrings(%bActive, "id_townspysafety", "Don't even try to say you can guarantee my safety here. I just showed you can't do that. I aim to be safely outta the area before I tell you anything more.");
   slgUpdateTaskStrings(%bActive, "id_findotherspy", "We'd best go see about Rock Ridge. We can make sure whoever the spy is over there doesn't hurt anyone, and we can make sure our own traitor's telling the truth about where the Mad Russian is.");
   // Disasters
   slgUpdateTaskStrings(%bActive, "id_firedisaster", "This place is gettin' mighty dry and that means fire. We better be prepared if we want to keep the town from burnin' down around our ears. I got a friend that'll teach ya' all ya' need to know about dealing with fire. We'll hold down the fort here 'till you get back.");
   
   // Map 1 End Task
   slgUpdateTaskStrings(%bActive, "id_EndtaskStart", "Now that we know the Mad Russian is based out of Gunslinger Gulch, it's time to head out that way. We'll need to have enough supplies to set up a new town out there before we go anywhere though.");
   slgUpdateTaskStrings(%bActive, "id_EndtaskQuest", "Let's gather up 500 ounces of gold and 500 planks of wood to take along with us. We'd best be sure we've got a nice steady supply coming in here too. An outpost'll guarantee that.");
   slgUpdateTaskStrings(%bActive, "Id_Loadmap2Accept", "500 ounces of gold, 500 planks of wood, and 20 bushels of food should get settled in at Gunslinger Gulch. I'll head off on my own, Oxbow Bend needs everyone else to keep working. Ready to go?");
   
}

function TaskListener::CombatTaskActive(%this, %bActive)
{
   slgUpdateTaskStrings(%bActive, "ID_CombatIntro", "This is where Israel said those bandits were headed.  The folks from Hope River gotta be around here somewhere.");
   slgUpdateTaskStrings(%bActive, "ID_CombatHelp", "Bandits stole my merchandise, stole my gold, locked me out of my own store, and took the key.  You gotta help me out.");
   slgUpdateTaskStrings(%bActive, "ID_CombatHelp2", "We're looking for some bandits ourselves. Which way did yours go?");
   slgUpdateTaskStrings(%bActive, "ID_Combatdirect", "They headed off to the southwest. I think they mighta' crossed the river, but I was too busy tryin' to get into my store to tell for sure.");
   slgUpdateTaskStrings(%bActive, "ID_herotext1", "We'll keep an eye out while we're after our own.");
   slgUpdateTaskStrings(%bActive, "ID_Combatkey1", "Who's that? C'mon, drop the shovel and let's get 'em!");
   slgUpdateTaskStrings(%bActive, "ID_Combatkey2", "Dirty meddlin' meddlers. We'll show ya' how we deal with uh... meddlers.");
   slgUpdateTaskStrings(%bActive, "ID_Combatkey3", "You can't even get an insult out right, you theivin' banditos. Hand's up.");
   slgUpdateTaskStrings(%bActive, "ID_CombatTreasure", "Based on the shovels they were carrying, those bandits musta' buried the shopkeeper's stuff around here somewhere. Everybody spread out and look for it.");
   slgUpdateTaskStrings(%bActive, "ID_treasuredig", "The earth looks a might loose here. Why don't we try digging it up? After all, we still got those shovels.");
   slgUpdateTaskStrings(%bActive, "ID_Combatfind", "Hah! We hit pay dirt. And plenty of ordinary dirt as well.");
   slgUpdateTaskStrings(%bActive, "ID_chestpickup", "Looks like everything's here, including the store key.  Let's gets this back to the store.");
   slgUpdateTaskStrings(%bActive, "ID_tntstorecomplete", "Thanks so much. Most of my merchandise is a bit roughed up, but I'll sell you all the dynamite you can carry.");
   slgUpdateTaskStrings(%bActive, "ID_woodtrade", "Those bandits sure did a number on my poor shop. I'll need some extra wood to repair it and I'd be happy to trade you gold for any extra wood you might have.");
   slgUpdateTaskStrings(%bActive, "ID_woodtradesale", "I'll give you 100 gold for a bundle of 80 wood.");
   slgUpdateTaskStrings(%bActive, "ID_buydynamite", "I'll sell you 1 stick of dynamite for 100 gold.");
   // Dyanmite Cliff zone
   slgUpdateTaskStrings(%bActive, "ID_cliffzone", "These rocks look loose, I bet we can blast through them if we had some dynamite.");
   // Bandit Camp
   slgUpdateTaskStrings(%bActive, "ID_combathelp3", "We're in here! Get us away from these varmints!");
   slgUpdateTaskStrings(%bActive, "ID_bandithelp", "Quiet you. Prisoners ain't supposed to talk. And you nosy do-gooders, buzz off, or it'll go bad for you.");   
   slgUpdateTaskStrings(%bActive, "ID_combatrescue1", "Oh those were just beastly bandits. Thank you so much for rescuing us.");
   slgUpdateTaskStrings(%bActive, "ID_combatrescue2", "They kept talking about how some Russian guy was going to pay them real well for kidnapping people from Hope River.");
   slgUpdateTaskStrings(%bActive, "ID_combatrescuehero", "Well ain't that just a coincidence. Well, at least you're safe now.");
   slgUpdateTaskStrings(%bActive, "ID_combatwait", "With Hope River all burned out, we ain't got no place to call our own, so we're gonna go back to your town with you.");
   slgUpdateTaskStrings(%bActive, "ID_combatreturn", "We're all ready to go back whenever you are.");
   slgUpdateTaskStrings(%bActive, "ID_combatbarricade", "Looks like someone doesn't want anyone snooping over there.");
   // Trapped Gunslingers
   slgUpdateTaskStrings(%bActive, "ID_combatotherside", "Hey I thought I heard someone.");
   slgUpdateTaskStrings(%bActive, "ID_combatgunslingerhelp", "Is there anyone out there? Please, you gotta help us. Those loose-necked good-for-nothin's barricaded us in this tumble-down chunka' logs.");
   slgUpdateTaskStrings(%bActive, "ID_combatgunslingerokay", "Who barricaded you what? Oh, nevermind. How can we help?");
   slgUpdateTaskStrings(%bActive, "ID_combatgunslingerdynamite", "You have to blow up the barricade without bringing down the whole cabin. Just don't set the dynamite off too close to the cabin and we should be okay. Please don't blow us up. Please.");
   slgUpdateTaskStrings(%bActive, "ID_combatcabindestroy", "Thanks for nothin'. You didn' listen to our words, so now you can listen to our guns.");
   slgUpdateTaskStrings(%bActive, "ID_combatgunfree", "Ah, you're a life saver. We're happy to help you go after those desperados that stuck us in there.");
}

function TaskListener::FireTutorialActive(%this, %bActive)
{
   slgUpdateTaskStrings(%bActive, "id_firetut_intro",   "Howdy there. Glad you're here, I saw some smoke comin' out of that general store. I think there's a fire started inside.");
   slgUpdateTaskStrings(%bActive, "id_firetut_explain", "Yup! There it goes! Move a character onto the burning building to have him or her put it out. Make sure you've got a Well!");
   slgUpdateTaskStrings(%bActive, "id_firetut_congrat", "There we go. Nice and charred, but not burning anymore.");
   slgUpdateTaskStrings(%bActive, "id_firetut_return",  "You can stick around here and get more practice, or you can head back to Oxbow Bend.");
}

function TaskListener::BridgeTutorialActive(%this, %active)
{
   slgUpdateTaskStrings(%active, "id_bridgetut_intro", "Welcome! Friend of mine got trapped when the river flooded. I'd appreciate it if you'd build a bridge over to his cabin. Select your Hero, click on the Build Button, then open the second tab.");
   slgUpdateTaskStrings(%active, "id_bridgetut_build", "Click on the Bridge button, then place the Bridge across the river so that its base is green."); 
   slgUpdateTaskStrings(%active, "id_bridgetutorial_cross", "Head on across the bridge to talk to " @ btciv2.name @ " and learn more about Bridges. Just move your Hero to the other side of the river.");
   slgUpdateTaskStrings(%active, "id_bridgetut_place", "Thank goodness someone's here. Now then, I have a delivery waiting at the cabin to the northeast. You'll have to build one more Bridge to get there.");
   slgUpdateTaskStrings(%active, "id_bridgetut_placetwo", "In order to build a Bridge in that direction, you'll have to click the Rotate Building button once you've selected a Bridge to build. It is just above the Build Menu.");
   slgUpdateTaskStrings(%active, "id_bridgetut_placeagain", "That Bridge isn't going to get you where you need to go. Try building one across the river to the northeast. You'll have to rotate the Bridge before you can place it.");
   slgUpdateTaskStrings(%active, "id_bridgetut_pickupcrate", "Ah... you're here to pick up " @ btciv2.name @ "'s delivery. The crate is right beside my Cabin. I know he wants it right away, so you should grab it and hurry back to him.");
   slgUpdateTaskStrings(%active, "id_bridgetut_done", "Thanks for bringin' me the last of my collectible plates. All I needed was Annie Oakley. You can head on back to your own town any time.");
}

function TaskListener::EscortActive(%this, %active)
{
   slgUpdateTaskStrings(%active, "id_escort_intro", "Hey, over here. You best keep me safe 'till we get back to real civilization. Remember, I don't say a peep until I'm safe.");
   slgUpdateTaskStrings(%active, "id_escort_warning1", "Y'all really heading out there with " @ Escortee.name @ "? Well, nice knowin' ya. Ain'tcha heard? One'a the gangs put a bounty on his head. A big one.");
   slgUpdateTaskStrings(%active, "id_escort_warning2", "Well, some things are worth a little danger. If we can make it past the large boulders just outside of the treeline, we should be fine. Let's get going.");
   slgUpdateTaskStrings(%active, "id_escort_treeline1", "Well howdy, " @ Escortee.name @ ". Fancy meetin' you out here. You look lonely, why don't we keep you company while we go back to meet with the bosses?");
   slgUpdateTaskStrings(%active, "id_escort_treeline2", "He's got plenty of company right now. Better company than you'd be.");
   slgUpdateTaskStrings(%active, "id_escort_treeline3", "You may've got past us... but you'll never get past the Campfire Copperheads");
   slgUpdateTaskStrings(%active, "id_escort_campfire1", "Wait, 'bosses?' As in, more than one?");
   slgUpdateTaskStrings(%active, "id_escort_campfire2", "Yeah, the two guys who run the gang.");
   slgUpdateTaskStrings(%active, "id_escort_campfire3", "Heh Heh. If it ain't our good friend " @ Escortee.name @ ". That bounty's gonna buy me a new toupee.");
   slgUpdateTaskStrings(%active, "id_escort_campfire4", "I'd almost hand him over if you'd actually use the money on that. Almost, but not quite.");
   slgUpdateTaskStrings(%active, "id_escort_campfire5", "That weren't very nice. That's okay... you'll get what's comin' to you once ya cross the river.");
   slgUpdateTaskStrings(%active, "id_escort_river1", "So you said there were two guys running your gang? Not just the Mad Russian?");
   slgUpdateTaskStrings(%active, "id_escort_river2", "Naw... they just brought that costume out for a laugh.");
   slgUpdateTaskStrings(%active, "id_escort_river3", "Well look who we got here. A little turncoat. Stick 'em up, law-dogs. We're takin' this rat with us.");
   slgUpdateTaskStrings(%active, "id_escort_river4", "Stick 'em up yourselves, you dirty rustlers.");
   slgUpdateTaskStrings(%active, "id_escort_river5", "This is getting' downright dangerous. I ain't sayin' nothin' more 'till I'm safe.");
   slgUpdateTaskStrings(%active, "id_escort_hostage", "These good-fer-nothin' snakes tied me up while I was sleepin'. You deal with them, I'll give you a hand in tannin' their hides.");
   slgUpdateTaskStrings(%active, "id_escort_losedialog", "Well, that plan didn't work. Should we try something else or just pretend this never happened?");
   slgUpdateTaskStrings(%active, "id_escort_sheriffnotsafe", "Whoa there Nellie. Looks like you have a whole mess of outlaws after you. I'd love to help, but I just got my hat bleached. Once you've dealt with them, I'll be happy to take that scoff-law off your hands.");
   
   slgUpdateTaskStrings(%active, "id_escort_sheriff", "Good to see you made it through. Heard there might'a been some trouble but I couldn't get here in time to help out. I'll take " @ Escortee.name @ " the rest of the way.");
   slgUpdateTaskStrings(%active, "id_escort_winAccept", "I promised to tell ya what I knew, so here it is. The guy in the Russian outfit is based up around Gunslinger Gulch. Now take me to safety, tin-star.");
  
   slgUpdateTaskStrings(%active, "id_escort_restartbutton", "Retry Mission");
   slgUpdateTaskStrings(%active, "id_escort_quitbutton", "Abort Mission");
}

function TaskListener::SpyPuzzleActive(%this, %active)
{
   slgUpdateTaskStrings(%active, "id_spypuzzle_intro", "Sheriff, you got a spy for those no-good Copperheads in town. What can you tell me about the folks here-abouts?");
   slgUpdateTaskStrings(%active, "id_spypuzzle_sheriff", "Other than me, there's two people in Rock Ridge who tell nothing but the truth, and three who lie " @
      "at least some of the time. I'm sure the liars will lie about who the Spy is though. I just don't have the heart to question them myself.");
   slgUpdateTaskStrings(%active, "id_spypuzzle_messageAlpha", civB.name @ " and " @ civE.name @ " never lie. That " @ civB.name @ " has been skulking around though, I think she's the spy.");
   slgUpdateTaskStrings(%active, "id_spypuzzle_messageBeta", " I caught " @ civC.name @ " out in a lie the other day. Don't bother looking at the men in town though, only a woman would be clever enough to be a spy.");
   slgUpdateTaskStrings(%active, "id_spypuzzle_messageCod", civD.name @ " is a darn fibber and I saw " @ civA.name @ " talking to someone with a funny accent.");
   slgUpdateTaskStrings(%active, "id_spypuzzle_messageDelta", civE.name @ " lies, but I know she isn't the spy.");
   slgUpdateTaskStrings(%active, "id_spypuzzle_messageEther", civB.name @ " and " @ civC.name @ " lie all the time. I wouldn't trust any of the men in Rock Ridge... one of them is bound to be your spy.");
   slgUpdateTaskStrings(%active, "id_spypuzzle_accusewrong", "I'm no spy! You'd better be right next time, or that spy is bound to get away.");
   slgUpdateTaskStrings(%active, "id_spypuzzle_accuseright", "I confess, I'm the spy. I didn't want to, but he found out that I collect funny-shaped cow-pies. I couldn't let that information get out! Oh no... um... if I tell you that the Mad Russian is based down around Gunslinger Gulch, will you forget you heard that?");
   slgUpdateTaskStrings(%active, "id_spypuzzle_accusedialog", "Are you really going to accuse me of being the spy?");
   slgUpdateTaskStrings(%active, "id_spypuzzle_accuseaccept", "Accuse");
   slgUpdateTaskStrings(%active, "id_spypuzzle_accusecancel", "Think On It");
   slgUpdateTaskStrings(%active, "id_spypuzzle_losedialog", "I'm not the spy either, dang it. Now the real spy got away! What are you going to do about that?");
   slgUpdateTaskStrings(%active, "id_spypuzzle_restartbutton", "Try Again");
   slgUpdateTaskStrings(%active, "id_spypuzzle_quitbutton", "Give Up");
   slgUpdateTaskStrings(%active, "id_spypuzzle_Sheriffaccept", "I cant believe it was you. Well, I can take it from here. Thanks for your help.");
}

function TaskListener::OutpostTasksActive(%this, %active)
{
   slgUpdateTaskStrings(%active, "id_outpost_gold", "Heard tell of some rich gold fields near here. If we started up a settlement out there, we could ship the gold here. We'll need some resources to start the settlement though. 200 ounces of gold, 200 planks of wood, and 20 bushels of food should be enough.");
   slgUpdateTaskStrings(%active, "id_outpost_wood", "There's a huge forest not too far from here. We could set up a nice settlement out there to bring in lumber. We'll need 200 ounces of gold, 200 planks of wood, and 20 bushels of food to get settled if we go.");
   slgUpdateTaskStrings(%active, "id_outpost_food", "Head out and set up a settlement that'll bring food into town. You'll need something to start up with. 200 ounces of gold, 200 planks of wood, and 20 bushels of food should be enough.");
}

function TaskListener::OutpostGoldActive(%this, %active)
{
   slgUpdateTaskStrings(%active, "id_outpostgold_intro", "Great gobs of gold... this place is rich as all get-out. If we can build up a couple of mines and some way to get the gold back to town, we'll have a nice steady source of income.");
   slgUpdateTaskStrings(%active, "id_outpostgold_platform", "Now that we have the mines started, all we need to do is set up the trade route back to town.");
   slgUpdateTaskStrings(%active, "id_outpostgold_resource", "That's everything set up. Maybe I'd best get a nice little stock of gold set aside to make sure we have a nice steady stream coming in.");
   slgUpdateTaskStrings(%active, "id_outpostgold_complete", "Great! This is just what we needed. Might as well get on back to town and spend some of this new-found wealth.");
}

function TaskListener::OutpostWoodActive(%this, %active)
{
   slgUpdateTaskStrings(%active, "id_outpostwood_intro", "Wow, that's a lot of leafy lumber. If we can get some logging operations and a wagon trail set up out here, we'll be able to ship wood back to town by the... well, by the wagon-load.");
   slgUpdateTaskStrings(%active, "id_outpostwood_platform", "That's the wood huts all set up. Now we've just got to get the wagon route back to town set up.");
   slgUpdateTaskStrings(%active, "id_outpostwood_resource", "Alright. We've got wood being collected, we've got a route back to town, now we should build up a nice stockpile to keep things flowing into town smoothly.");
   slgUpdateTaskStrings(%active, "id_outpostwood_complete", "That should about do it. We can take the first load of lumber back to town any time now.");
}

function TaskListener::OutpostFoodActive(%this, %active)
{
   slgUpdateTaskStrings(%active, "id_outpostfood_intro", "Great grassy gopher-town. With so many fertile fields and fish-filled ponds, this place is a real breadbasket. We should set up some farms and ranches so we can ship food straight back to town.");
   slgUpdateTaskStrings(%active, "id_outpostfood_platform", "Well, that should bring food in pretty quick. Now we've just got to set up a steady way to get the food back to town.");
   slgUpdateTaskStrings(%active, "id_outpostfood_resource", "Now that we've got a wagon route and plenty of food, let's gather up a whole whack of grain and dried fish so we don't have to worry about any lapses in the food supply.");
   slgUpdateTaskStrings(%active, "id_outpostfood_complete", "Let's see, bunch of farms gathering food, steady route back to town, big stockpiles of food ready to be sent out. Yup, I think our work here is done.");
}

function TaskListener::BridgeDefenseActive(%this, %bActive)
{
   slgUpdateTaskStrings(%bActive, "id_bridgedef_intro",    "I heard there was a problem with the bridge here. How can we help?");
   slgUpdateTaskStrings(%bActive, "id_bridgedef_story",    "Bandits done blew it up. If we can keep our lumber mill sawin' away, we should be able'a rebuild the bridges. But I think them bandits is still in the area.");
   slgUpdateTaskStrings(%bActive, "id_bridgedef_response", "Well then, we'd best keep some folks with guns around the mill while we get bridging.");
   slgUpdateTaskStrings(%bActive, "id_bridgedef_halfway",  "We're gettin' close. We've just got to hold those bandits off a little while longer.");
   slgUpdateTaskStrings(%bActive, "id_bridgedef_confront", "I knew we'd catch somethin' if we stayed in them barrels! The Rustlers ride agai-- I mean get 'em, Copperheads.");
   slgUpdateTaskStrings(%bActive, "id_bridgedef_conres",   "The only thing you've caught is lead.");
   slgUpdateTaskStrings(%bActive, "id_bridgedef_win",      "Roll on away, you barrel-riding bandits!");
   slgUpdateTaskStrings(%bActive, "id_bridgedef_mayor",    "Thank goodness ya' got here, things were startin' to get desperate. The only outhouse we got is across the river.");
   slgUpdateTaskStrings(%bActive, "id_bridgedef_exit",     "There you go, folks. Looks like our job here is done. We can head back to Town whenever.");
   slgUpdateTaskStrings(%bActive, "id_bridgedef_lose",     "Oh no, there goes the lumber mill! That's gonna slow us down something fierce.");
}

function TaskListener::BadSeedActive(%this, %bActive)
{
   slgUpdateTaskStrings(%bActive, "id_badseed_introstart",  "You've gotta help us. Some out of town jasper of a farmer, uh--Mr. Jasper, got his hands on our deeds, and he's threatening to take our homes away if we don't get him 1,200 ounces of gold.");
   slgUpdateTaskStrings(%bActive, "id_badseed_introend",    "Well then I suppose we'll just have to stay organized and get Mr. Jasper his money.");
   slgUpdateTaskStrings(%bActive, "id_badseed_bldgloss",    "You've run out of time. Since you can't pay, I'm going to call in the deed on one of your buildings.");
   slgUpdateTaskStrings(%bActive, "id_badseed_bldglossdialog", "That just ain't fair. The fact that it's all legal ain't got nothing to do with it. We best hurry before he buys up more of our buildings.");
   slgUpdateTaskStrings(%bActive, "id_badseed_payoffstart", "We've got the gold, let's get it to Mr. Jasper so he'll stop repossessing our buildings.");
   slgUpdateTaskStrings(%bActive, "id_badseed_payoffmid",   "What? How in the blazes were you able to gather that much gold? That crazy Russian type won't be happy, so I'll see to it that you aren't either!");
   slgUpdateTaskStrings(%bActive, "id_badseed_payoffend",   "Hrm... maybe we'd best get some more guns hired on here just in case he tries something rash.");
   slgUpdateTaskStrings(%bActive, "id_badseed_denoument",   "Thank you, as a representative of the Second International Bank of the West, I'll take the gold and provide you with the deeds to this town.");

}

function TaskListener::TownHallDefenseActive(%this, %bActive)
{
   slgUpdateTaskStrings(%bActive, "id_thd_intro",            "Phew, what a walk. Tailingtown is just up ahead. Let's find this blacksmith and see if he can fix that dang key.");
   slgUpdateTaskStrings(%bActive, "id_thd_entertownciv",     "I'm so glad y'all are here. Those bandits could be comin' after our Treasure any time now. Oh! The Mayor said he wanted to talk to you.");
   
   slgUpdateTaskStrings(%bActive, "id_thd_entertownmay",     "Thank goodness you're here. The Treasure of Tailingtown isn't safe in the town hall, but we won't have anywhere safer to put it until we've built a bank.");
   slgUpdateTaskStrings(%bActive, "id_thd_enterresponse",    "Wait? You're under attack? We weren't coming to help with no attack. We're looking for the famous blacksmith who lives around these parts.");
   slgUpdateTaskStrings(%bActive, "id_thd_enterblacksmith",  "Oh, you mean Henry Pound. The same dadgummed bandits wrecked his smithy and ran him off. I'm sure he'll come back once our Treasure's safe, and the town with it.");
   
   slgUpdateTaskStrings(%bActive, "id_thd_treasure",         "I ain't surprised those bandits are coming after the Treasure of Tailingtown. Ain't no one 'round who wouldn't want it.");
   slgUpdateTaskStrings(%bActive, "id_thd_blacksmith",       "We'll need to have a blacksmith in town to build the vault at the bank. At least, if we expect it to be strong enough to keep people away from the Treasure.");
   
   slgUpdateTaskStrings(%bActive, "id_thd_bankattack",       "You think some silly vault's gonna keep us away from your treasure? C'mon, let's show 'em just who they're dealing with.");
   slgUpdateTaskStrings(%bActive, "id_thd_bankdefend",       "Looks like this is the big push. We'd best get everyone over to the bank.");
   slgUpdateTaskStrings(%bActive, "id_thd_bankattackwin",    "That should do for those banditos. I don't think we'll be seeing their sort around here again.");
   slgUpdateTaskStrings(%bActive, "id_thd_smithyback",       "Hey there. I was watchin' from the edge of the woods. You rebuilt my smithy and drove off the bandits. What can I do to repay you?");
   slgUpdateTaskStrings(%bActive, "id_thd_smithyhelp",       "Ah-ha! Just the man we were looking for. I've got this key that's plumb broke in half and I need a copy made.");
   slgUpdateTaskStrings(%bActive, "id_thd_smithyemploy",     "Be happy to make one for ya'. I just need to get at that anvil for a moment.");
   slgUpdateTaskStrings(%bActive, "id_thd_smithyfixkey",     "There you go, good as new. The gate those bandits are usin' should open just fine now. Uh... I mean.. have fun with your new key.");
   
   slgUpdateTaskStrings(%bActive, "id_thd_endheroquestion",  "Man I wish I knew what that treasure was... just don't seem right to do all that and not find out what it is. Sure wish there was someone left to ask.");
   slgUpdateTaskStrings(%bActive, "id_thd_endheroask",       "So now that we got the bank built and your Treasure's secure, I have to know, what is it?");
   slgUpdateTaskStrings(%bActive, "id_thd_endcivexplain",    "Well, seeing as you helped out, I guess we can tell you. The Treasure of Tailingtown is this genu-ine box of tailings. The first outta our mine.");
   slgUpdateTaskStrings(%bActive, "id_thd_endheroresponse",  "Wait. Tailings? Like the bits of rock you pull up out of a mine that aren't gold?");
   slgUpdateTaskStrings(%bActive, "id_thd_endbanditexclaim", "Are you fer real? We did all that for a buncha rock? I thought that Treasure was somethin' real nice. Sheee-oot.");
   slgUpdateTaskStrings(%bActive, "id_thd_exit",             "Well... the Treasure of Tailingtown is safe once again. Not that I think anyone else'll by coming by to steal it now that word's out as to what it is. Best get back to town.");
}

function TaskListener::DeadMineActive(%this, %bActive)
{
   slgUpdateTaskStrings(%bActive, "id_dm_intro",                "Looks like there's a whole series of caverns down here. ");
   slgUpdateTaskStrings(%bActive, "id_dm_cavewall",             "Hey... there's somethin' written on this here wall. Says to find the tomb where the still water runs clear for a golden secret.");
   slgUpdateTaskStrings(%bActive, "id_dm_tomb",                 "It's not just a name on this gravestone. It says that there's a great treasure under the rock off westward of this tomb.");
   slgUpdateTaskStrings(%bActive, "id_dm_cavewallgoldmine",     "Will ya lookit that? This here gold vein goes all the way to the surface. We should be able to build a new mine on it when we get back."); 
   slgUpdateTaskStrings(%bActive, "id_dm_storezone",            "I don't know if I should trust you lot. For all I know you're the same buncha scoff-laws what kidnapped mah best friend.");
   slgUpdateTaskStrings(%bActive, "id_dm_aboutfriend",          "That's too bad. To prove we're on the up and up, we'll keep an eye out for your friend while we're down here if you tell us what he looks like.");
   slgUpdateTaskStrings(%bActive, "id_dm_explainfriend",        "She. What SHE looks like. She's got beautiful brown hair, a gorgeous straight nose--oh, fine, she's a horse. But she's still mah best friend.");
   slgUpdateTaskStrings(%bActive, "id_dm_offerdynamite",        "Tell you what. You bring her back to me, I'll sell you some dynamite. A touch'a TNT comes in handy down here.");
   slgUpdateTaskStrings(%bActive, "id_dm_alreadyhavehorse",     "We already got a horse down here... brown mane, nice long nose, good hauler? Yup, looks like it's the right one. She's mighty glad to see you.");
   slgUpdateTaskStrings(%bActive, "id_dm_havehorse",            "We got your horse now... wasn't even all that hard. Hey now... looks like she's happy to see you.");
   slgUpdateTaskStrings(%bActive, "id_dm_bestfriendback",       "Well of course she is. Thanks a heap for helpin' me out. Isn't that right snookums? Who's a good girl.. who's a pretty girl...");
   slgUpdateTaskStrings(%bActive, "id_dm_horserescueforce",     "Not gonna pay up, are ya? We'll see about that.");
   slgUpdateTaskStrings(%bActive, "id_dm_selldynamite",         "Ah, now then. Just 80 ounces of gold for a nice keg of dynamite. Ya won't find a better deal anywhere else around here.");
   slgUpdateTaskStrings(%bActive, "id_dm_goldzonewarn",         "Don't know who you folks is, but I do know ya shouldn't be down here. Now skeedadle.");
   slgUpdateTaskStrings(%bActive, "id_dm_goldzoneattack",       "We done told ya to scoot. Now yer gonna pay fer bein' so nosy.");
   slgUpdateTaskStrings(%bActive, "id_dm_goldzonewin",          "Those certainly were some nasty customers. Having people like that down here doesn't fill me with confidence as to what happened to our gold.");
   slgUpdateTaskStrings(%bActive, "id_dm_horserescuefound",     "Pst... hey you. Wanna buy a horse? We'll sell her to ya real cheap.");
   slgUpdateTaskStrings(%bActive, "id_dm_horserescuepay",       "Just 100 ounces of gold for this prime haulin' horse.");
   slgUpdateTaskStrings(%bActive, "id_dm_horserescuefight",     "That horse doesn't belong to you. Hand her over.");
   slgUpdateTaskStrings(%bActive, "id_dm_horserescuepaid",      "Heh. Thanks for the cash. I hate havin' to dig it up myself.");
   slgUpdateTaskStrings(%bActive, "id_dm_horserescueattack",    "You're not going to get away with this!");
   slgUpdateTaskStrings(%bActive, "id_dm_horserescuezonefight", "Hey, get away from there. No touching the merchandise!");
   slgUpdateTaskStrings(%bActive, "id_dm_horserescuewinfight",  "That'll teach 'em to steal someone else's horse.");
   slgUpdateTaskStrings(%bActive, "id_dm_outsidewall",          "The cavern wall looks mighty thin here. I bet we could blow it away with a stick or two of dynamite.");
   slgUpdateTaskStrings(%bActive, "id_dm_banditcamp",           "What are you squares doin' here? Yer not supposed to be comin' into yer own mine from that side. Tell you what. The Mad Russian'll give you 500 ounces of gold to just jander off and give up yer claim.");
   slgUpdateTaskStrings(%bActive, "id_dm_sellmine",             "Well... 500 ounces is a whole lot of gold. Why don't we sell the mine to them?");
   slgUpdateTaskStrings(%bActive, "id_dm_soldgoldmine",         "Thanks for the mine. Buyin' it outright sure is a whole lot easier than stealin' it. No hard feelin's, eh?");
   slgUpdateTaskStrings(%bActive, "id_dm_fightformine",         "What? This is our mine and it's worth a whole lot more than 500 ounces of gold. You'd best skeddadle and fast.");
   slgUpdateTaskStrings(%bActive, "id_dm_returntomain",         "Now that that's dealt with, I guess it's time to get back up to the surface.");
}

function TaskListener::SnakeValleyActive(%this, %bActive)
{
   slgUpdateTaskStrings(%bActive, "id_snakevalley_intro",         "Let's get moving. We've got to get through to that nest of snakes before they all get away.");
   slgUpdateTaskStrings(%bActive, "id_snakevalley_pitopen",       "Will you look at that... looks like some sort of pit trap. Let's take a gander at what's inside.");
   slgUpdateTaskStrings(%bActive, "id_snakevalley_pitopentwo",    "What do you know, a sack of gold. That seems like an odd thing to have down in a pit.");
   
   slgUpdateTaskStrings(%bActive, "id_snakevalley_waterman",      "Woo-ee. Didn't expect to see no one but them bandits up here. I'm right glad to see y'all.");
   slgUpdateTaskStrings(%bActive, "id_snakevalley_replytowater",  "Sorry friend, we don't have time to chat. We've got a job to do.");
   slgUpdateTaskStrings(%bActive, "id_snakevalley_dynamitepit",   "How many of these dang pits are there? Well, guess we might as well see what's in this one too.");
   slgUpdateTaskStrings(%bActive, "id_snakevalley_dynamiteboom",  "Yeowtch! Someone rigged that pit up with dynamite! That wasn't very nice of them.");
   slgUpdateTaskStrings(%bActive, "id_snakevalley_tntboom",       "Woah horsey! My ears are ringing. We better be careful around here.");

   slgUpdateTaskStrings(%bActive, "id_snakevalley_archway",       "I'm not so sure about looking in this pit... they seem a bit dangerous. Oh well, here's hoping for no boom...");
   slgUpdateTaskStrings(%bActive, "id_snakevalley_archwayopen",   "No boom? Well that's nice. And a fat sack of gold, too. That's twice as nice.");
   slgUpdateTaskStrings(%bActive, "id_snakevalley_beginleft",     "Hey, somethings glittering like gold down there in that pit. It IS gold! These pits are profitable!");
   slgUpdateTaskStrings(%bActive, "id_snakevalley_zilch",         "There doesn't seem to be nothing in this pit. Smells like folks were storing meat here though--woah, what's that?");
   slgUpdateTaskStrings(%bActive, "id_snakevalley_sasquatch",     "I thought I taw a puddy tat! ...I did! I did tee a puddy cat!");
   slgUpdateTaskStrings(%bActive, "id_snakevalley_wood",          "What's down in this pit? Lumber? What in the heck would someone put lumber in a pit for?.");
   slgUpdateTaskStrings(%bActive, "id_snakevalley_fence",         "I bet if we had some dynamite we could blast through that fence.");
   slgUpdateTaskStrings(%bActive, "id_snakevalley_mainreturn",    "Dang, it's a REAL snake's nest. Wait... nope, something's down here. 'Copperhead Franchise #324 Founding Charter?' We best take this back to town...");
   slgUpdateTaskStrings(%bActive, "id_bottleneck_pitopen",        "Eek! There's dynamite down here! Oh... phew, looks like it didn't go off. Bet we could use that somewhere 'round here. And look, a treasure chest!");
   slgUpdateTaskStrings(%bActive, "id_bottleneck_bandits",        "Boo! Stick 'em up!");
   slgUpdateTaskStrings(%bActive, "id_dryguy_dryguyparch",        "I'm parched. Y'all got any water? I'd do just about anything for a drop of water.");
   slgUpdateTaskStrings(%bActive, "id_dryguy_herotodryguy",       "We'll see what we can do about that.");
   slgUpdateTaskStrings(%bActive, "id_dryguy_needwater",          "Did I say a drop of water? I bet I could drink 5 canteens bone dry. Tell you what, you get me that, and I'll help you out.");
   slgUpdateTaskStrings(%bActive, "id_dryguy_herofindwater",      "Say... that's a nice looking well you got there. Think you could spare some water?");
   slgUpdateTaskStrings(%bActive, "id_dryguy_waterprice",         "Didn't wanna chat, eh? Well, then I'll let you fill up yer canteens for 20 ounces of gold.");
   slgUpdateTaskStrings(%bActive, "id_dryguy_buywater",           "Gold makes up for a whole lotta not talkin'. Oh yeah, watch out f'r pits 'round here. I been huntin' bears, an' you don' wanna get caught.");
   slgUpdateTaskStrings(%bActive, "id_dryguy_getwater",           "Ah... tastes as sweet as lemonade. Say, you don't have any... naw, lemme just climb outta here, and we'll get a move on.");
   slgUpdateTaskStrings(%bActive, "id_bandpit_pitopen",           "Lookie there... another one of those pits. I sure hope this one's something nice.");
   slgUpdateTaskStrings(%bActive, "id_bandpit_surprise",          "Stop right there, varmints. Pst... now Velma... now...");
   slgUpdateTaskStrings(%bActive, "id_bandpit_defeat",            "Whew... I wouldn't want to sit down there waiting for someone to wander by. Doesn't sound like much fun to me.");
   slgUpdateTaskStrings(%bActive, "id_spearpit_response",         "Ouchie. Let's not stick around. Ha ha. Ow... laughing hurts.");
}

function TaskListener::FamineTaskActive(%this, %bActive)
{
   // Intro and hints
   slgUpdateTaskStrings(%bActive, "id_famine_intro",     "All our wells done been tampered with. We went out and got what we needed to fix 'em, but now none of us can remember just what box fixes what well.");
   slgUpdateTaskStrings(%bActive, "id_famine_introtwo",  "Each cure will only work for one well but I forgot which crate goes to which well. The other folks 'round here might remember somethin' more. I just know we gotta hurry, or we're gonna have to sell our land to the Copperheads.");
   slgUpdateTaskStrings(%bActive, "id_famine_hinttwo",   "I know we didn't put any box right next to the well that it would fix. That woulda been smart of us.");
   slgUpdateTaskStrings(%bActive, "id_famine_hintthree", "I remember that when it smells like eggs, you're supposed to put in the stuff that looks like pebbles, 'cause they also look like eggs.");
   slgUpdateTaskStrings(%bActive, "id_famine_hintfour",  "Well, the netting certainly ain't gonna help with the well that's all iron-y... the iron's already dissolved.");
   
   // Object name strings
   slgUpdateTaskStrings(%bActive, "id_famine_wellone",  "A strong stench of rotten eggs comes from this well.");
   slgUpdateTaskStrings(%bActive, "id_famine_well2",    "There is a strong smell of iron here, and streaks of red run through the water.");
   slgUpdateTaskStrings(%bActive, "id_famine_well3",    "The water in this well tastes all salty.");
   slgUpdateTaskStrings(%bActive, "id_famine_well4",    "Uh... there's something floating in this well. I'm not sure I wanna know what it is.");
   slgUpdateTaskStrings(%bActive, "id_famine_wellbox1", "This box is filled with baking soda. Huh... you wouldn't think it'd be so heavy, but there's a whole lot of it.");
   slgUpdateTaskStrings(%bActive, "id_famine_wellbox2", "This box is filled with shavings of dried pine sap.  Mmm... smells nice.");
   slgUpdateTaskStrings(%bActive, "id_famine_wellbox3", "This box just has a bunch of netting in it.");
   slgUpdateTaskStrings(%bActive, "id_famine_wellbox4", "This box is filled with something that looks like little black pieces of gravel.");
   
   // Box placement strings
   slgUpdateTaskStrings(%bActive, "id_famine_wellbox1well1", "Do you want to put the baking soda in the well that smells like rotten eggs?");
   slgUpdateTaskStrings(%bActive, "id_famine_wellbox1well2", "Do you want to put the baking soda in the well that smells like iron?");
   slgUpdateTaskStrings(%bActive, "id_famine_wellbox1well3", "Do you want to put the baking soda in the well that's full of salt water?");
   slgUpdateTaskStrings(%bActive, "id_famine_wellbox1well4", "Do you want to put the baking soda in the well that has something floating in it?");
   slgUpdateTaskStrings(%bActive, "id_famine_wellbox2well1", "Do you want to put the dried sap in the well that smells like rotten eggs?");
   slgUpdateTaskStrings(%bActive, "id_famine_wellbox2well2", "Do you want to put the dried sap in the well that smells like iron?");
   slgUpdateTaskStrings(%bActive, "id_famine_wellbox2well3", "Do you want to put the dried sap in the well that's full of salt water?");
   slgUpdateTaskStrings(%bActive, "id_famine_wellbox2well4", "Do you want to put the dried sap in the well that has something floating in it?");
   slgUpdateTaskStrings(%bActive, "id_famine_wellbox3well1", "Do you want to use the netting in the well that smells like rotten eggs?");
   slgUpdateTaskStrings(%bActive, "id_famine_wellbox3well2", "Do you want to use the netting in the well that smells like iron?");
   slgUpdateTaskStrings(%bActive, "id_famine_wellbox3well3", "Do you want to use the netting in the well that's full of salt water?");
   slgUpdateTaskStrings(%bActive, "id_famine_wellbox3well4", "Do you want to use the netting in the well that has something floating in it?");
   slgUpdateTaskStrings(%bActive, "id_famine_wellbox4well1", "Do you want to put the funny black gravel in the well that smells like rotten eggs?");
   slgUpdateTaskStrings(%bActive, "id_famine_wellbox4well2", "Do you want to put the funny black gravel in the well that smells like iron?");
   slgUpdateTaskStrings(%bActive, "id_famine_wellbox4well3", "Do you want to put the funny black gravel in the well that's full of salt water?");
   slgUpdateTaskStrings(%bActive, "id_famine_wellbox4well4", "Do you want to put the funny black gravel in the well that has something floating in it?");
   
   // Crate names
   slgUpdateTaskStrings(%bActive, "id_famine_wellbox1name", "Baking Soda");
   slgUpdateTaskStrings(%bActive, "id_famine_wellbox2name", "Pine Resin");
   slgUpdateTaskStrings(%bActive, "id_famine_wellbox3name", "Netting");
   slgUpdateTaskStrings(%bActive, "id_famine_wellbox4name", "Black Gravel");
   
   // End strings
   slgUpdateTaskStrings(%bActive, "id_famine_lose",         "Uh... somehow I don't think you did that right. Things are getting worse, not better. At this rate, we'll have to sell to the Copperheads right away.");
   slgUpdateTaskStrings(%bActive, "id_famine_tryagain",     "We've got a new shipment in, let's try again.");
   slgUpdateTaskStrings(%bActive, "id_famine_restart",      "Dang it... that didn't work, and we're outta food.");
   slgUpdateTaskStrings(%bActive, "id_famine_win",          "That's it! The wells are producing clean, fresh water again. Now we won't have to sell our land to those dirty Copperheads.");
   slgUpdateTaskStrings(%bActive, "id_famine_returntomain", "Glad I could help. I best be gettin' back to my own town now though.");
}

function TaskListener::Campaign2TasksActive(%this, %bActive)
{
   // Intro Dialog
   slgUpdateTaskStrings(%bActive, "ID_CampaignIntro", "So this is Gunslinger Gulch. Not much to look at, I have to say. The big Copperhead base both the spies told us about must be just across the river. If we can deal with them, we can find exactly where the Mad Russian is hiding.");
   // Zone Dialog
   slgUpdateTaskStrings(%bActive, "ID_Map2WagonBridge", "Woah now... I'm not going to cross that rickety old bridge. We'd best find another way over there.");
   // Bake Off Trigger
   slgUpdateTaskStrings(%bActive, "ID_BakeoffAccept", "Hi! I just opened up a bakery down the road, and I'm trying to line up a steady supply of flour. Would you be able to help me complete just a few small orders? Please?");
   // Secret Animal Map
   slgUpdateTaskStrings(%bActive, "ID_MapAnimaltrapSpot", "Will you look at that... there a horse runin' wild up north of the town. Poor thing's all lathered up an' thirsty looking.");
   slgUpdateTaskStrings(%bActive, "ID_MapAnimalThirst", "Looks like you can not only lead a horse to water, but you can make it drink. It sure is drinkin' a lot... I hope it ain't a racehorse.");
   slgUpdateTaskStrings(%bActive, "ID_MapAnimalfound", "Well howdy folks. I'm right glad you found my horse, he sorta got away from me. Y'all sure are good with animals, if you got a spare moment I could use some help.");
   slgUpdateTaskStrings(%bActive, "ID_MapAnimalAccept", "I got a few animals what need roundin' up. Won't take but a moment, I guarantee it.");
   // Return Text   
   slgUpdateTaskStrings(%bActive, "ID_MapAnimaltrapReturn", "Yup, here's your two magnificent mammals. You can raise 'em at a ranch and build an empire based on 'em. What are they? Sheep of course.");
   
   // Gate Dialog
   slgUpdateTaskStrings(%bActive, "ID_CampaignGateZone", "That's one dang sturdy gate. Don't think we'll be able to blow it open. Wait... I think I hear voices on the other side.");
   slgUpdateTaskStrings(%bActive, "ID_CampaignGateBanditkey", "What kinda dimwit'd lose the key to the front gate? Oh, right, you would.");
   slgUpdateTaskStrings(%bActive, "ID_CampaignGateBanditlost", "Will you quit yellin' at me? I tol' you, I know I had it when I went on my tour of my favorite swimmin' holes. Now I don't. Doesn't matter no-how, I, uh, kinda broke it in half.");
   slgUpdateTaskStrings(%bActive, "ID_CampaignGateBanditmad", "You WHAT? I just don't know why I dang well put up with you.");
   slgUpdateTaskStrings(%bActive, "ID_CampaignGateIdea", "Hey, I bet if we could find those parts'a the key, we could have our blacksmith forge a whole one. Then we could get in and surprise 'em.");
   slgUpdateTaskStrings(%bActive, "ID_CampaignGateBanditnoise", "Hey did you hear something?");
   // Swimming hole Dialog
   slgUpdateTaskStrings(%bActive, "ID_CampaignNokey", "Ain't no key here, just a muddy pair of drawers. Musta been laundry day too. Guess we'll have to check the other swimmin' holes.");
   slgUpdateTaskStrings(%bActive, "ID_Campaign1stkey", "Hah! There's somethin' shiny in here... yup, it's a key! Dang... no, it's only half a key. Still, we're halfway there, just need the other part.");
   slgUpdateTaskStrings(%bActive, "ID_Campaign2ndkey", "Yee-haw! Found the other half of the key. Let's get it back to the blacksmith right quick.");
   // Forging the key Dialog
   slgUpdateTaskStrings(%bActive, "ID_CampaignEmploysmithy", "We'll need to employ someone as a Blacksmith in order to make a matchin' key.");
   slgUpdateTaskStrings(%bActive, "ID_CampaignBlacksmith", "A new key to match these two halves? Not a problem. I'll have it done in two shakes of a lamb's tail.");
   slgUpdateTaskStrings(%bActive, "ID_CampaignBuildsmithy", "We need to build some place for a Blacksmith to work in order to forge a matching key.");
   slgUpdateTaskStrings(%bActive, "ID_Campaignkeycomplete", "Well shoot-shucky-darn. This is gonna to be harder than I thought.  There's only one person I know what can match this workmanship.  Luckily, he lives just over the rise in Tailingtown.");
   slgUpdateTaskStrings(%bActive, "ID_CampaignTownHallAccept", "The road over to Tailingtown is pretty dangerous, maybe we better bring some extra gunslingers along. Just let me know when we're ready to go.");
   slgUpdateTaskStrings(%bActive, "ID_Campaignpickupkey", "Now we've got ourselves a copy of the key to the gate. Let's go give those bandits a surprise they'll never get over.");
   slgUpdateTaskStrings(%bActive, "ID_CampaignOpengate", "That's it... it worked, the gate's open. Now be vewy vewy qwiet. We'we huntin' bandits.");
   // Bandit Battle
   slgUpdateTaskStrings(%bActive, "ID_CampaignPhonyRussian", "You'll never take me alive! I vill escape once again!");
   slgUpdateTaskStrings(%bActive, "ID_CampaignBanditsDefeat", "They sure don't make bandits like they used to, do they?");
   slgUpdateTaskStrings(%bActive, "ID_CampaignPhonySurrender", "Okay, okay, I give up, stop shooting, I ain't the guy you're after. Mr. White and Mr. Wong paid me good money to wear this outfit, but my name's Kevin, and I'm from Nebraska Territory.");
   slgUpdateTaskStrings(%bActive, "ID_CampaignPhonywin", "Kevin? From Nebraska? And they thought you would be able to pull off a Russian accent? Well, tell us where they're at, and we just might let you off.");
   slgUpdateTaskStrings(%bActive, "ID_CampaignLoadWowAccept", "Sure, sure. Just don't hurt me. There's a trail they take between their two camps. One calls it the Wong Way, the other calls it the White Way. I'll show you where it is.");
   // Treasure Hunt 2
   slgUpdateTaskStrings(%bActive, "ID_Treasurehunt2Secret", "That explosion blasted something out of the stump. It's a bit of paper that says, 'Only building a well in the sand trap will uncover the key to my treasure.'");
   slgUpdateTaskStrings(%bActive, "ID_Treasurehunt2Sandtrap", "Dangnabit, our building collapsed! The ground must be too sandy to support a building 'round here.");
   slgUpdateTaskStrings(%bActive, "ID_Treasurehunt2Well", "Woah, I found a key and a note when we was diggin' out for the well. Says, 'To find my treasure first find the shelter in the woods that isn't a tree.'");
   slgUpdateTaskStrings(%bActive, "ID_Treasurehunt2openCabin", "The cabin's locked. I wonder if that key we found in the sand will work here. I mean, I guess it's sorta shelter, even if it's fallin' down.");
   slgUpdateTaskStrings(%bActive, "ID_Treasurehunt2Cabin", "Great. I found another rusty old key and a miner's hat in the cabin. That's real danged helpful.");
   slgUpdateTaskStrings(%bActive, "ID_Treasurehunt2OpenDoor", "This door look as old and rusty as the key we found in the cabin, might as well see if they go together.");
   slgUpdateTaskStrings(%bActive, "ID_Treasurehunt2entercave", "Well whaddya know, it worked! And there's a whole heap of gold and wood inside!");
   // Lists what you've found plus random xp item
   slgUpdateTaskStrings(%bActive, "ID_Treasurehunt2reward", "Whoever built this place packed in upwards of 600 planks of wood and 600 ounces of gold. And there's these funny plans with a whole lotta pipes involved. Maybe it's for a fountain?");
   // Enter cave zone before trigger task
   slgUpdateTaskStrings(%bActive, "ID_Treasurehunt2Door", "This danged door is rusted clear shut. I don't know if even dynamite'd blast it open.");
   
   // Text after White/Wong choice, which leads to Capture Mad Russian satellite
   slgUpdateTaskStrings(%bActive, "id_wow_blamedlg1", "Look! The Mad Russian is burning your town! I'm telling you, it's all his fault, I really didn't do anything wrong.");
   slgUpdateTaskStrings(%bActive, "id_wow_blamedlg2", "But didn't you start a bunch of franchise Copperhead gangs, all causin' trouble?");
   slgUpdateTaskStrings(%bActive, "id_wow_blamedlg3", "Well... technically... yes. But only in order to draw lawmen from all around the West after the Mad Russian. Look over there! Everything's on fire!");
   slgUpdateTaskStrings(%bActive, "id_wow_prepforrussian1", "Now look. I know the Mad Russian's going to have a lot of real Copperheads up at his hideaway. We should get up there as soon as we can and try to take him by surprise.");
   slgUpdateTaskStrings(%bActive, "id_wow_prepforrussian2", "Hold your horses there, Mister. After what happened last time, I don't want to leave Gunslinger Gulch without protection and someone to watch over it. We'd best make sure we've got a good Mayor and Sheriff to look out for the place before we leave.");
   slgUpdateTaskStrings(%bActive, "id_wow_prepforrussian3", "Fine, fine, fine. Just hurry up. We need to take that villain down before it's too late.");
   slgUpdateTaskStrings(%bActive, "id_wow_prepforrussian4", "Villain? Do I need to remind you that you're one of the ones who started up new Copperhead gangs? I'm glad you're helping us, but you're not in the clear yet.");
   slgUpdateTaskStrings(%bActive, "id_mrc_trigger", "Alright. Gunslinger Gulch should be pretty well protected now. We can head out whenever we're ready.");
   // Snake Valley Map Trigger
   slgUpdateTaskStrings(%bActive, "ID_MapSnakeValleyTrigger", "A whole nest of Copperheads just moved into one'a my supply bases. You clear 'em out for me, I'll hand over the family business. Tradin's gettin' too dangerous with those snakes 'round.");
   slgUpdateTaskStrings(%bActive, "ID_MapSnakeValleyAccept", "I'll give you some directions up to where the Copperheads is. Might want some guns at yer side. Them Copperheads're nasty critters. Just let me know when you're ready to go.");

   slgUpdateTaskStrings(%bActive, "id_snakevalley_return1", "This franchise notice is signed by some guys named Barnabas White and Wong Fu.");
   slgUpdateTaskStrings(%bActive, "id_snakevalley_return2", "I heard Kaylee and Simon from Lightning Bluff talk about Wong. He was one of the Mad Russian's henchmen who got hung out to dry. But who's White?");
   slgUpdateTaskStrings(%bActive, "id_snakevalley_return3", "Not me, hah-hah. Get it? Who's right? Okay, so it wasn't all that funny.");
   
   // Tornado Valley Map Trigger
   slgUpdateTaskStrings(%bActive, "ID_MapTornadoIntro", "Say, you heard about the Blooming Big Challenge? Huge cash reward involved, and I'd be willin' to split it with you. What's the catch? Well, do the words 'Tornado Valley' mean anythin' to you?");
   slgUpdateTaskStrings(%bActive, "ID_MapTornadoValleyAccept", "I'm sure Tornado Valley can't be so bad as all the stories. And it's a reward of a full 2,000 ounces of gold that I'm talkin' about splittin' with you. Whatcha say?");
   
   //Final Final Dialog
   //From the Mad Russian:
   slgUpdateTaskStrings(%bActive, "ID_endgamewhiteone", "Ve did vhat you asked. The ungrateful Wong is behind bars. I vant real retirement. Now ve are free to go, da?");
   //From the Mad Russian:
   slgUpdateTaskStrings(%bActive, "ID_endgamewongone", "Ve did vhat you asked. The maniac White is behind bars. I vant real retirement. Now ve are free to go, da?");
   //From the Hero:
   slgUpdateTaskStrings(%bActive, "ID_endgamehero", "Yes, you're free to go. I don't expect any trouble out of either of you going forward, you hear? I want a chance to rest on my laurels a bit, not go haring off after you two, so stay on the straight and narrow.");
   //From White:
   slgUpdateTaskStrings(%bActive, "ID_endgamewhitetwo", "Of course. I promise I won't cause any trouble. And I believe that our friend Vostrikov here is suitably chastened as well. I'm sure you'll grow to miss the constant attention, but that's your own fault.");
   //From Wong:
   slgUpdateTaskStrings(%bActive, "ID_endgamewongtwo", "You know, I sort of enjoyed having the tin-stars on my side, instead of chasing after me. I might find some town out there and become a Sheriff. Good luck here, and enjoy your retirement, Doc.");
   //From the Hero or other suitable icon (the logo?):
   slgUpdateTaskStrings(%bActive, "ID_endgameCongrats", "Congratulations, you've completed the major storyline of Westward II. You can continue building up Gunslinger Gulch if you would like, or play through again and see how you fare making different choices along the way.");
   
}

function TaskListener::WhiteWongTaskActive(%this, %bActive)
{
   slgUpdateTaskStrings(%bActive, "id_wow_introone", "That fake Russian, Kevin, said that the White Way and the Wong Way came right through here.");
   slgUpdateTaskStrings(%bActive, "id_wow_introend", "Help! Help! We backed the Wong guy, and the White guy set our town on fire!");

   slgUpdateTaskStrings(%bActive, "id_wow_firehelpthanks", "Phew. That was some quick work. Couldn't have done it without you. Yeah, those two were arguing and fighin' when they came through here. Sayin' this one was White, and that one was Wong. Uh, I mean right and wrong.");
   slgUpdateTaskStrings(%bActive, "id_wow_firehelwelcome", "Not a problem... we're after them anyhow, we'll make sure that this doesn't happen to y'all again. Those two have been on the Wong side of the law too long. White? Er, right?");
   slgUpdateTaskStrings(%bActive, "id_wow_firehelpend", "That's a lot of fire! We'd best focus on the buildings we need most.");
   slgUpdateTaskStrings(%bActive, "id_wow_battle1", "You idiots are following the Wong boss. Anyone can tell you that lookin' out for number one is better than revenge.");
   slgUpdateTaskStrings(%bActive, "id_wow_battle2", "Of course we're workin' for the Wong guy. You White-minded nincompoops wouldn't know a good thing if it bit you. Revenge is where the money's at.");
   slgUpdateTaskStrings(%bActive, "id_wow_battle3", "Who the heck are those department-store cowboys? I don't think they came the White Way.");
   slgUpdateTaskStrings(%bActive, "id_wow_battle4", "I definitely think they came the Wong Way. Whatcha say, put aside our differences to show 'em the error of their ways?");
   slgUpdateTaskStrings(%bActive, "id_wow_battlestart", "Uh... maybe we should have shown up just a bit later. That's a lot of six-shooters.");
   slgUpdateTaskStrings(%bActive, "id_wow_whiteargue", "You two-bit con-man. Vostrikov never would have known I was here if it wasn't for you. Now that Mad Russian's after me again. I never should have listened to you about starting up all those franchises.");
   slgUpdateTaskStrings(%bActive, "id_wow_wongargue", "Who are you calling two-bit? You don't even have two cents to put into the discussion. I never should have listened to YOU about starting up all those franchises.");
   slgUpdateTaskStrings(%bActive, "id_wow_endargument", "It's gotten rather quiet down there... what, who's that down there? Lawmen? Up here? Your silly plan worked TOO well, Wong. Well, they can't catch both of us.");
   slgUpdateTaskStrings(%bActive, "id_wow_whitechoice", "Should we go after Mr. White, the new piece of the puzzle? Sounds like he doesn't like the Mad Russian, maybe he'll tell us where the Mad Russian really is.");
   slgUpdateTaskStrings(%bActive, "id_wow_wongchoice", "Should we go after Mr. Wong? He was pretty helpful to the folks of Lightning Bluff, once he was properly motivated. He might be able to tell us where the Mad Russian really is.");
   slgUpdateTaskStrings(%bActive, "id_wow_returntomain", "Well, at least we captured one of the troublemakers, although the other one got away. Back to Gunslinger Gulch with this one.");
   slgUpdateTaskStrings(%bActive, "id_wow_tntpit", "Oof! Now that weren't very nice.");
   slgUpdateTaskStrings(%bActive, "id_wow_prisonerdialog", "What are you chasing me for? It's that other troublemaker who started all this! Fine! Fine! Stop shooting, I give up.");
   slgUpdateTaskStrings(%bActive, "id_wow_escapeedialog", "Hah! Too slow, tin-stars. Stopping to catch him means you'll never catch me!");
}

function TaskListener::MadRussianCaptureActive(%this, %bActive)
{
   slgUpdateTaskStrings(%bActive, "id_mrc_intro", "Now we've finally caught up to the nefarious Mad Russian, the one who's been behind all--erm, almost all, of the problems we've been having.");
   slgUpdateTaskStrings(%bActive, "id_mrc_ambuscadefaceoff", "Stick 'em u--hrm, there are a lot of y'all, aren't there?");
   slgUpdateTaskStrings(%bActive, "id_mrc_watchinitwarn", "Uh oh. That guy came from the watchtower. I guess we better be careful of getting too close to them.");
   slgUpdateTaskStrings(%bActive, "id_mrc_watchinitstopbandit", "Quick, stop him before he can spread the alarm.");
   slgUpdateTaskStrings(%bActive, "ID_MRC_Gunslingerhelp", "Looks like you chummers could use a spot of help. We'll help ya out, but it'll cost ya..");
   slgUpdateTaskStrings(%bActive, "ID_MRC_GunslingerAccept", "120 ounces of gold'll hire you the fastest guns in the West. Whatcha say?");
}

function TaskListener::MadRussianConfrontationActive(%this, %bActive)
{
   slgUpdateTaskStrings(%bActive, "id_mrc_madrussianattack", "I did not vant to get back into the old business, but vith all of you lawmen comink after me, I had no choice. So now it is time to say dasvedanya, lawmen.");
   slgUpdateTaskStrings(%bActive, "id_mrc_madrussianenddlg", "Look. Is not my fault. Lawmen are coming after me for doing nothink, so I figure I might as well do somethink since they're after me already. But it was those other two who started it.");
   //If White, then:
   slgUpdateTaskStrings(%bActive, "id_mrc_whiteenddlg", "It wasn't MY fault. That silly little man Wong kept saying how he would have his revenge for being left out to dry. I just wanted to make some money. I'm sure I could arrange for you all to show up at just the Wong time for him.");
   //If Wong, then:
   slgUpdateTaskStrings(%bActive, "id_mrc_wongenddlg", "Sure, Doc V left me out to dry back in Lightning Bluff, but I didn't hold a grudge. It was that Mr. White, always muttering about how he had to take care of the Mad Russian or he wouldn't get any peace. I'd be happy to show you White where he's based.");
   slgUpdateTaskStrings(%bActive, "id_mrc_heroenddlg", "Well then, I guess we got our work cut out for us. We'd best leave most of the posse here to make sure none of the Copperheads sneak off in the confusion.");
}

function TaskListener::FoodBakerTaskActive(%this, %bActive)
{
   slgUpdateTaskStrings(%bActive, "id_fb_intro", "This is right about where Jillian said her bakery was. Mmm... that smells wonderful. The scent's coming from the east, must be off that way.");
   slgUpdateTaskStrings(%bActive, "id_fb_onzone1", "In order to keep my customers happy, I need to get these cakes baked quickly, and for that, I need flour as soon as I get one set of cakes out the door! I won't have room for it all if I get the flour while I'm baking.");
   slgUpdateTaskStrings(%bActive, "id_fb_onzone2", "Sounds good, just so long as you keep some of those delicious cakes for me.");
   slgUpdateTaskStrings(%bActive, "id_fb_begin", "I need to keep working here, but as I'll get as many of my friends as possible to give you a hand. Let's get baking! First off, I need 15 bags of flour in exactly one minute.");
   slgUpdateTaskStrings(%bActive, "id_fb_failquota1", "Ohhh... I needed that flour now. Without a steady supply of flour, I can't make my cakes, and my customers go away unhappy.");
   slgUpdateTaskStrings(%bActive, "id_fb_succeedquota1", "Yay! I finally got a break, but everyone says they're going to tell their friends about the wonderful cakes, so we've got more baking to do! If you could get me 25 bags of flour in 3 minutes, that would be great.");
   slgUpdateTaskStrings(%bActive, "id_fb_failquota2", "I can't bake anything if I don't have enough flour!");
   slgUpdateTaskStrings(%bActive, "id_fb_succeedquota2", "Good Job! That's another bunch of cakes out the door. Of course, that means more customers. This time, I'll need 35 bags of flour in 4 minutes.");
   slgUpdateTaskStrings(%bActive, "id_fb_failquota3", "I really needed that flour. Well, maybe I'm not cut out for this whole baking business.");
   slgUpdateTaskStrings(%bActive, "id_fb_succeedquota3", "Hooray! That's another batch of cakes out the door. Just a couple more big jobs and I should be able to make a deal with a full-time flour supplier. I've already got a ton of orders though, I'll need 45 bags of flour in 5 minutes to fill them all.");
   slgUpdateTaskStrings(%bActive, "id_fb_failquota4", "Shoot. I needed that flour to be there on time. I'm not going to be able to meet all my orders!");
   slgUpdateTaskStrings(%bActive, "id_fb_succeedquota4", "This is going to be the big one. Harris Pilton hired me to make cakes for his wedding. He's invited so many people that I'm going to need 50 bags of flour 6 minutes from now.");
   slgUpdateTaskStrings(%bActive, "id_fb_failquota5", "Oh no! Mr. Pilton isn't going to be happy.");
   slgUpdateTaskStrings(%bActive, "id_fb_succeedquota5", "Harris loved the cakes! Oh, and he said I could call him Harris. It's all so exciting, I couldn't have done it without you.");
   slgUpdateTaskStrings(%bActive, "id_fb_fail", "Oh no! We didn't get enough dough... or money! We'll never be able to keep the Evans bakery running this way.");
   slgUpdateTaskStrings(%bActive, "id_fb_win", "That's it! I have enough money to make a deal with a steady flour supplier. Thanks so much for all of your help.");
}

function TaskListener::ThreeAmigosTaskActive(%this, %bActive)
{
   slgUpdateTaskStrings(%bActive, "id_threeamigo1", "Well howdy there. Aren't you handsome devils.");
   slgUpdateTaskStrings(%bActive, "id_threeamigo2", "That's like snow calling freshly cleaned sheets white.");
   slgUpdateTaskStrings(%bActive, "id_threeamigo3", "And charming too... I think this is the beginning of a beautiful friendship.");
}

function TaskListener::FinalShowdownActive(%this, %bActive)
{
   slgUpdateTaskStrings(%bActive, "id_final_introone", "The nefarious villain is holed up on the other side of the river. We'll have to take considerable care, as his defenses are not insignificant.");
   slgUpdateTaskStrings(%bActive, "id_final_introtwo", "I can't vait. The things I'm goink to do vhen I get my hands on that dirty Mr. W--");
   slgUpdateTaskStrings(%bActive, "id_final_FinalShowdownIntro", "Easy there, Doctor Vostrikov. You're still on the wrong side of the trust line. Don't go making promises you can't keep. We'll build up a base of operations here before we cross the river.");
   slgUpdateTaskStrings(%bActive, "id_final_BanditBaseOneSlingerDialog", "You're here for the key, eh? Somehow I always knew you'd turn traitor and work with the law-dogs. You ain't gettin' that key without a fight.");
   slgUpdateTaskStrings(%bActive, "id_final_BanditBaseOneKeyDialog", "Right then. That should get us through that gate. Onwards and upwards.");
   slgUpdateTaskStrings(%bActive, "id_final_BanditBaseTwoSlingerDialog", "No unwanted visitors've ever gotten past the Outer Gate. Wait... that means you took down my buddy up north. Oooh, you'll pay fer that.");
   slgUpdateTaskStrings(%bActive, "id_final_BanditBaseTwoKeyDialog", "I'm always amazed at how many people will take the quick road instead of the high road.");
   slgUpdateTaskStrings(%bActive, "id_finalBanditBaseTwoKeyDialogTwo", "You're still amazed after spendink time with that fast-talkink rat who led you to me? I'm amazed you found me even vith his help.");
   
   // GATE NO KEY DIALOG
   slgUpdateTaskStrings(%bActive, "id_final_GateOneNoKeyIntroDialog", "Hey Do-gooder! Over here!");
   slgUpdateTaskStrings(%bActive, "id_final_GateOneNoKeyWoWDialog", "That is to say, my good friend. If we're going to get into the villain's inner sanctum and preserve the peace of your precious settlements, we'll need a key.");
   slgUpdateTaskStrings(%bActive, "id_final_NoKeyBanditOneDlg", "The despicable bandits up to the north have the key. Just finish them off, and we can get right in.");
   slgUpdateTaskStrings(%bActive, "id_final_NoKeyEndWoWDialog", "And don't even think about blasting the gates. They're far too strong, and the noise would just draw out more of those vile bandits.");
   slgUpdateTaskStrings(%bActive, "id_final_GateTwoNoKeyIntroDialog", "A slight problem over here...");
   slgUpdateTaskStrings(%bActive, "id_final_GateTwoNoKeyWoWDialog", "It appears that our indomnible villain has further fortified himself in my absense. There's another gate.");
   slgUpdateTaskStrings(%bActive, "id_final_NoKeyBanditTwoDlg", "Well, there's only one area where the key to this gate could be. It's just off to the south of here.");
   
   // FINAL DIALOG
   slgUpdateTaskStrings(%bActive, "id_final_FinalShowdownWoWDlg", "You? You? And You? All in one place? I should have known. Quickly, get them! I'll retreat to the Manor and... uh... arrange for reinforcements.");
   slgUpdateTaskStrings(%bActive, "id_final_FinalShowdownWoWSurrenderDlg", "No! I can't believe a bunch of cretins like yourselves brought me low.");
   slgUpdateTaskStrings(%bActive, "id_final_FinalShowdownHeroWinDlg", "That's it! That's the last of the troublesome characters. Oxbow Bend and Gunslinger Gulch should be safe from here on out--and so should the other towns in the area.");
   //If playing White:
   slgUpdateTaskStrings(%bActive, "id_final_WinTwoWhiteDlg", "Mr. White, Doc V, you've proven yourselves so far. Give me a hand dragging Wong Fu back to Gunslinger Gulch so we can put him behind bars and you'll be free to go.");
   //If playing Wong:
   slgUpdateTaskStrings(%bActive, "id_final_WinTwoWongDlg", "Mr. Wong, Doc V, you've proven yourselves so far. Give me a hand dragging Barnabas White back to Gunslinger Gulch so we can put him behind bars and you'll be free to go.");
}

function TaskListener::TornadoValleyTasksActive(%this, %bActive)
{
   slgUpdateTaskStrings(%bActive, "ID_TornadoStart", "We got a few tents set up just ahead, but with all the wind whippin through here, it ain't been easy to keep 'em up. Follow me.");    
   slgUpdateTaskStrings(%bActive, "ID_TornadoBasecamp", "Welcome to Tornado Valley. They said it was crazy, but when you're as rich as the Bloom family, it's usually called eccentric. Dorothy Bloom is offerin' a prize to anyone who can build up a successful town here in the Valley.");
   slgUpdateTaskStrings(%bActive, "ID_TornadoMainTask", "But to claim the prize the town has to be big and the citizens gotta be happy. Oh, an' feel free to use any supplies layin' around. We started on our own, but didn't get very far before you showed up.");
   slgUpdateTaskStrings(%bActive, "ID_TornadoWin", "Will you look at that? Don't look too hard, what with all the grit blowin' 'round. But I gotta say, that's one big, happy town. I think we may've won the prize.");
   slgUpdateTaskStrings(%bActive, "ID_TornadoEndAccept", "Yup, the place looks great. But the sky's turnin' funny colors again. Let's go claim our reward before another twister hits.");
}

function TaskListener::SandboxTasksActive(%this, %bActive)
{
   slgUpdateTaskStrings(%bActive, "ID_SandboxIntro", "Welcome to Sandbox Mode. There are two ways to play, Open Range and Disaster Challenge. Open Range allows you to develop things at your own pace, while Disaster Challenge will steadily increase the chance of environmental disasters as you play.");    
   slgUpdateTaskStrings(%bActive, "ID_SandboxFreeplayText", "Welcome to Open Range mode. All buildings begin play unlocked and no environmental disasters will take place.");    
   slgUpdateTaskStrings(%bActive, "ID_SandboxChallengeText", "Welcome to Disaster Challenge mode. The game starts with low chances of environmental disasters and that chance increases over time, with experience and gold being awarded each time the disaster level increases.");
   // Mad Russian/Pioneer Badge - From Mad Russian.
   slgUpdateTaskStrings(%bActive, "ID_madrussianbadge", "Now that I am retired, I am havink too much time on my hands. I vill be helpink you out here. No, no, don't thank me. Just say 'Da' and we will be gettink to vork.");
   slgUpdateTaskStrings(%bActive, "id_DisasterRules", "In Disaster Challenge Gold, Wood and Experience is rewarded for each new disaster level reached.  Bonus experience is rewarded for each town citizen you have.");
}

function TaskListener::AnimalTrapTasksActive(%this, %bActive)
{
   slgUpdateTaskStrings(%bActive, "ID_AnimalTrapIntro", "Glad you could make it. We're definitely gonna need all the help we can get capturing--uh, re-capturing these animals.");    
   slgUpdateTaskStrings(%bActive, "ID_AnimalTrapHero", "What do you need me to do?");    
   slgUpdateTaskStrings(%bActive, "ID_AnimalTrapPlan", "Should be real easy. Get the animals to chase you into a holding pen and then run out the back. Just make sure not to get too close. Oh, an' try not to hurt the animals.");    
   slgUpdateTaskStrings(%bActive, "ID_AnimalTrapCapture", "We need to capture a deer, a bear, and the elusive Sasquatch. My crack group of Gunslingers'll help with the captures. Oh yeah, make sure each animal ends up in a different holding pen.");    
   slgUpdateTaskStrings(%bActive, "ID_AnimalTrapCaughtAll", "That's the last of them.");    
   slgUpdateTaskStrings(%bActive, "ID_AnimalTrapComplete", "Hah! I knew you could do it! Now we got all the animals we need for the famous P.T. Bailey's Westward Circus. Thanks a heap, friend. As a thank you, I'll give you a breeding pair of the world's most wonderous animal.");    
   slgUpdateTaskStrings(%bActive, "ID_AnimalTrapHeroDeath", "Argh... but they looked so cute and fuzzy.");    
   
}

// End client_taskstrings.cs
